/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.base.AbstractIterator;
import kala.collection.base.Iterators;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableSeq;
import kala.collection.immutable.ImmutableSeq;
import kala.collection.mutable.AbstractMutableList;
import kala.collection.mutable.MutableSinglyLinkedList;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class ImmutableLinkedSeq<E>
extends AbstractImmutableSeq<E>
implements Serializable {
    private static final long serialVersionUID = -2711437988200648694L;
    private static final Factory<?> FACTORY = new Factory();
    private static final Node<?> NIL_NODE = new Node();
    public static final ImmutableLinkedSeq<?> EMPTY = new ImmutableLinkedSeq(NIL_NODE, 0);
    private final Node<E> node;
    private final int size;

    @NotNull
    private static <E> Node<E> nilNode() {
        return NIL_NODE;
    }

    ImmutableLinkedSeq(Node<E> node, int size) {
        this.node = node;
        this.size = size;
    }

    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableLinkedSeq<E> narrow(ImmutableLinkedSeq<? extends E> seq) {
        return seq;
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, ImmutableLinkedSeq<E>> factory() {
        return FACTORY;
    }

    public static <E> ImmutableLinkedSeq<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of() {
        return ImmutableLinkedSeq.empty();
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1) {
        return new ImmutableLinkedSeq<E>(new Node<E>(value1, ImmutableLinkedSeq.nilNode()), 1);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2) {
        return new ImmutableLinkedSeq<E>(new Node<E>(value1, new Node<E>(value2, ImmutableLinkedSeq.nilNode())), 2);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3) {
        return new ImmutableLinkedSeq<E>(new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, ImmutableLinkedSeq.nilNode()))), 3);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3, E value4) {
        return new ImmutableLinkedSeq<E>(new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, new Node<E>(value4, ImmutableLinkedSeq.nilNode())))), 4);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new ImmutableLinkedSeq<E>(new Node<E>(value1, new Node<E>(value2, new Node<E>(value3, new Node<E>(value4, new Node<E>(value5, ImmutableLinkedSeq.nilNode()))))), 5);
    }

    @SafeVarargs
    @NotNull
    public static <E> ImmutableLinkedSeq<E> of(E ... values) {
        return ImmutableLinkedSeq.from(values);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(E @NotNull [] values) {
        int size = values.length;
        if (size == 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> node = ImmutableLinkedSeq.nilNode();
        for (int i = values.length - 1; i >= 0; --i) {
            node = new Node<E>(values[i], node);
        }
        return new ImmutableLinkedSeq<E>(node, size);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull List<? extends E> values) {
        return ImmutableLinkedSeq.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Iterable<? extends E> values) {
        if (values instanceof ImmutableLinkedSeq) {
            return (ImmutableLinkedSeq)((Object)values);
        }
        return ImmutableLinkedSeq.from(values.iterator());
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Iterator<? extends E> it) {
        Node<E> res;
        if (!it.hasNext()) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(it.next());
        int c = 1;
        while (it.hasNext()) {
            t.tail = new Node<E>(it.next());
            t = t.tail;
            ++c;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, c);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(ImmutableLinkedSeq.factory());
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, E value) {
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> res = ImmutableLinkedSeq.nilNode();
        for (int i = 0; i < n; ++i) {
            res = new Node<E>(value, res);
        }
        return new ImmutableLinkedSeq<E>(res, n);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(supplier.get());
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(supplier.get());
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, n);
    }

    @NotNull
    public static <E> ImmutableLinkedSeq<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        Node<E> res;
        if (n <= 0) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> t = res = new Node<E>(init.apply(0));
        for (int i = 1; i < n; ++i) {
            Node<E> nl = new Node<E>(init.apply(i));
            t.tail = nl;
            t = nl;
        }
        t.tail = ImmutableLinkedSeq.nilNode();
        return new ImmutableLinkedSeq<E>(res, n);
    }

    @Override
    @NotNull
    public String className() {
        return "ImmutableLinkedSeq";
    }

    @Override
    @NotNull
    public <U> CollectionFactory<U, ?, ImmutableLinkedSeq<U>> iterableFactory() {
        return ImmutableLinkedSeq.factory();
    }

    @NotNull
    public Iterator<E> iterator() {
        if (this.node == NIL_NODE) {
            return Iterators.empty();
        }
        if (this.node.tail == NIL_NODE) {
            return Iterators.of(this.node.head);
        }
        return new NodeItr<E>(this.node);
    }

    @Override
    @NotNull
    public Iterator<E> iterator(int beginIndex) {
        Conditions.checkPositionIndex((int)beginIndex, (int)this.size);
        if (beginIndex == 0) {
            return this.iterator();
        }
        if (beginIndex == this.size) {
            return Iterators.empty();
        }
        Node<E> node = this.node;
        for (int i = 0; i < beginIndex; ++i) {
            node = node.tail;
        }
        return new NodeItr<E>(node);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int knownSize() {
        return this.size;
    }

    @Override
    public E get(int index) {
        Conditions.checkElementIndex((int)index, (int)this.size);
        Node<E> list = this.node;
        for (int i = 0; i < index; ++i) {
            list = list.tail;
        }
        return list.head;
    }

    @Override
    @NotNull
    public ImmutableLinkedSeq<E> reversed() {
        if (this.size == 0 || this.size == 1) {
            return this;
        }
        Node<E> node = this.node;
        Node<Object> res = NIL_NODE;
        while (node != NIL_NODE) {
            res = new Node(node.head, res);
            node = node.tail;
        }
        return new ImmutableLinkedSeq(res, this.size);
    }

    @Override
    @NotNull
    public Iterator<E> reverseIterator() {
        return ((ImmutableLinkedSeq)this.reversed()).iterator();
    }

    @NotNull
    public ImmutableSeq<E> cons(E value) {
        return new ImmutableLinkedSeq<E>(this.node.cons(value), this.size + 1);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> prepended(E value) {
        return new ImmutableLinkedSeq<E>(this.node.cons(value), this.size + 1);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> appended(E value) {
        if (this.isEmpty()) {
            return ImmutableLinkedSeq.of(value);
        }
        return super.appended(value);
    }

    @Override
    public E first() {
        return this.node.head();
    }

    @Override
    public E last() {
        if (this.node == NIL_NODE) {
            throw new NoSuchElementException();
        }
        Node<E> node = this.node;
        while (node.tail != NIL_NODE) {
            node = node.tail;
        }
        return node.head;
    }

    @Override
    @NotNull
    public ImmutableSeq<E> drop(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.size) {
            return ImmutableLinkedSeq.empty();
        }
        Node<E> list = this.node;
        for (int i = 0; i < n; ++i) {
            list = list.tail;
        }
        return new ImmutableLinkedSeq<E>(list, this.size - n);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> dropWhile(@NotNull Predicate<? super E> predicate) {
        int c = 0;
        Node<E> list = this.node;
        while (list != NIL_NODE && predicate.test(list.head)) {
            list = list.tail();
            ++c;
        }
        if (list == NIL_NODE) {
            return ImmutableLinkedSeq.empty();
        }
        if (c == 0) {
            return this;
        }
        return new ImmutableLinkedSeq<E>(list, this.size - c);
    }

    @Override
    @NotNull
    public ImmutableSeq<E> takeLast(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return ImmutableLinkedSeq.empty();
        }
        if (n >= this.size) {
            return this;
        }
        return this.drop(this.size - n);
    }

    private Object writeReplace() {
        return new SerializationReplaced(this);
    }

    private static final class Node<E> {
        E head;
        Node<E> tail;

        Node() {
        }

        Node(E head) {
            this.head = head;
        }

        Node(E head, @NotNull Node<E> tail) {
            this.head = head;
            this.tail = tail;
        }

        public E head() {
            if (this == NIL_NODE) {
                throw new NoSuchElementException("ImmutableList.Nil.head()");
            }
            return this.head;
        }

        @NotNull
        public Node<E> tail() {
            if (this == NIL_NODE) {
                throw new NoSuchElementException("ImmutableList.Nil.tail()");
            }
            return this.tail;
        }

        @Contract(value="_ -> new")
        @NotNull
        public Node<E> cons(E element) {
            return new Node<E>(element, this);
        }
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableSinglyLinkedList<E>, ImmutableLinkedSeq<E>> {
        private Factory() {
        }

        public MutableSinglyLinkedList<E> newBuilder() {
            return new MutableSinglyLinkedList();
        }

        public ImmutableLinkedSeq<E> build(MutableSinglyLinkedList<E> builder) {
            return builder.toImmutableLinkedSeq();
        }

        public void addToBuilder(@NotNull MutableSinglyLinkedList<E> builder, E value) {
            builder.append(value);
        }

        public MutableSinglyLinkedList<E> mergeBuilder(@NotNull MutableSinglyLinkedList<E> builder1, @NotNull MutableSinglyLinkedList<E> builder2) {
            return (MutableSinglyLinkedList)Builder.merge(builder1, builder2);
        }
    }

    private static final class NodeItr<E>
    extends AbstractIterator<E> {
        @NotNull
        private Node<? extends E> node;

        NodeItr(@NotNull Node<? extends E> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != NIL_NODE;
        }

        public E next() {
            if (this.node == NIL_NODE) {
                throw new NoSuchElementException("ImmutableListIterator.next()");
            }
            E v = this.node.head();
            this.node = this.node.tail();
            return v;
        }
    }

    private static final class SerializationReplaced<E>
    implements Serializable,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private ImmutableLinkedSeq<E> value;

        public SerializationReplaced() {
        }

        public SerializationReplaced(ImmutableLinkedSeq<E> value) {
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value.size());
            Iterator<E> iterator = this.value.iterator();
            while (iterator.hasNext()) {
                E v = iterator.next();
                out.writeObject(v);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Node<Object> node;
            int size = in.readInt();
            if (size == 0) {
                this.value = ImmutableLinkedSeq.empty();
                return;
            }
            Node<Object> tail = node = new Node<Object>(in.readObject());
            int c = 1;
            for (int i = 1; i < size; ++i) {
                tail.tail = new Node<Object>(in.readObject());
                tail = tail.tail;
                ++c;
            }
            tail.tail = ImmutableLinkedSeq.nilNode();
            this.value = new ImmutableLinkedSeq<Object>(node, c);
        }

        private Object readResolve() {
            return this.value;
        }
    }

    @ApiStatus.Internal
    public static abstract class Builder<E>
    extends AbstractMutableList<E> {
        Node<E> first = null;
        Node<E> last = null;
        int len = 0;
        private boolean aliased = false;

        static <E> Builder<E> merge(@NotNull Builder<E> b1, @NotNull Builder<E> b2) {
            int b1s = b1.len;
            if (b1s == 0) {
                return b2;
            }
            if (b1s == 1) {
                b2.prepend(b1.first.head);
                return b2;
            }
            int b2s = b2.len;
            if (b2s == 0) {
                return b1;
            }
            if (b2s == 1) {
                b1.append(b2.first.head);
                return b1;
            }
            super.ensureUnaliased();
            super.ensureUnaliased();
            Node<E> b2f = b2.first;
            Node<E> b2l = b2.last;
            b2.clear();
            b1.last.tail = b2f;
            b1.last = b2l;
            b1.len = b1s + b2s;
            return b1;
        }

        private void ensureUnaliased() {
            if (this.aliased) {
                MutableSinglyLinkedList buffer = new MutableSinglyLinkedList();
                buffer.appendAll((Iterable)((Object)this));
                this.first = buffer.first;
                this.last = buffer.last;
                this.aliased = false;
            }
        }

        @NotNull
        public final Iterator<E> iterator() {
            Node<E> first = this.first;
            return first == null ? Iterators.empty() : new NodeItr<E>(first);
        }

        @Override
        @NotNull
        public Iterator<E> iterator(int beginIndex) {
            Conditions.checkPositionIndex((int)beginIndex, (int)this.len);
            if (beginIndex == this.len) {
                return Iterators.empty();
            }
            Node<E> node = this.first;
            for (int i = 0; i < beginIndex; ++i) {
                node = node.tail;
            }
            return new NodeItr<E>(node);
        }

        public final int size() {
            return this.len;
        }

        public final int knownSize() {
            return this.len;
        }

        @Override
        public final E get(int index) {
            Conditions.checkElementIndex((int)index, (int)this.len);
            if (index == this.len - 1) {
                return this.last.head;
            }
            Node<E> node = this.first;
            for (int i = 0; i < index; ++i) {
                node = node.tail;
            }
            return node.head;
        }

        @Override
        public final void swap(int index1, int index2) {
            int i;
            Conditions.checkElementIndex((int)index1, (int)this.len);
            Conditions.checkElementIndex((int)index2, (int)this.len);
            if (index1 == index2) {
                return;
            }
            this.ensureUnaliased();
            int i1 = Integer.min(index1, index2);
            int i2 = Integer.max(index1, index2);
            Node<E> node = this.first;
            for (i = 0; i < i1; ++i) {
                node = node.tail;
            }
            Node<E> node1 = node;
            while (i < i2) {
                node = node.tail;
                ++i;
            }
            Node<E> node2 = node;
            Object tmp = node1.head;
            node1.head = node2.head;
            node2.head = tmp;
        }

        @Override
        public final E first() {
            if (this.first == null) {
                throw new NoSuchElementException();
            }
            return this.first.head;
        }

        @Override
        public final E last() {
            if (this.last == null) {
                throw new NoSuchElementException();
            }
            return this.last.head;
        }

        public final boolean isEmpty() {
            return this.len == 0;
        }

        @Override
        public final void prepend(E value) {
            if (this.len == 0) {
                this.last = new Node<E>(value, ImmutableLinkedSeq.nilNode());
                this.first = this.last;
            } else {
                this.first = this.first.cons(value);
            }
            ++this.len;
        }

        @Override
        public final void append(E value) {
            Node<E> i = new Node<E>(value, ImmutableLinkedSeq.nilNode());
            if (this.len == 0) {
                this.first = i;
            } else {
                this.ensureUnaliased();
                this.last.tail = i;
            }
            this.last = i;
            ++this.len;
        }

        @Override
        public void insert(int index, E value) {
            if (index < 0 || index > this.len) {
                throw new IndexOutOfBoundsException("Index out of range: " + index);
            }
            if (index == 0) {
                this.prepend(value);
                return;
            }
            if (index == this.len) {
                this.append(value);
                return;
            }
            this.ensureUnaliased();
            Node<E> i = this.first;
            int c = 1;
            while (c++ != index) {
                i = i.tail;
            }
            i.tail = i.tail.cons(value);
            ++this.len;
        }

        @Override
        public final E removeAt(int index) {
            Conditions.checkElementIndex((int)index, (int)this.len);
            if (index == 0) {
                Object v = this.first.head;
                if (this.len == 1) {
                    this.last = null;
                    this.first = null;
                    this.aliased = false;
                } else {
                    this.first = this.first.tail;
                }
                --this.len;
                return v;
            }
            this.ensureUnaliased();
            Node<E> i = this.first;
            int c = 1;
            while (c++ != index) {
                i = i.tail();
            }
            E v = i.tail().head();
            i.tail = i.tail().tail();
            --this.len;
            return v;
        }

        @Override
        public final void clear() {
            this.last = null;
            this.first = null;
            this.len = 0;
            this.aliased = false;
        }

        @Override
        @NotNull
        public final ImmutableLinkedSeq<E> toImmutableLinkedSeq() {
            Node<E> first = this.first;
            if (first == null || first == NIL_NODE) {
                return ImmutableLinkedSeq.empty();
            }
            this.aliased = true;
            return new ImmutableLinkedSeq<E>(first, this.len);
        }

        @Override
        public final void set(int index, E newValue) {
            Conditions.checkElementIndex((int)index, (int)this.len);
            this.ensureUnaliased();
            if (index == this.len - 1) {
                this.last.head = newValue;
                return;
            }
            Node<E> l = this.first;
            while (--index >= 0) {
                l = l.tail;
            }
            l.head = newValue;
        }

        @Override
        public final void sort(Comparator<? super E> comparator) {
            if (this.len == 0) {
                return;
            }
            Object[] values = this.toArray();
            Arrays.sort(values, comparator);
            if (this.aliased) {
                Node<Object> newLast;
                Node<Object> newFirst = newLast = new Node<Object>(values[values.length - 1], ImmutableLinkedSeq.nilNode());
                for (int i = values.length - 2; i >= 0; --i) {
                    newFirst = new Node<Object>(values[i], newFirst);
                }
                this.first = newFirst;
                this.last = newLast;
                this.aliased = false;
            } else {
                Node<E> c = this.first;
                for (Object value : values) {
                    c.head = value;
                    c = c.tail;
                }
            }
        }

        @Override
        public final void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
            Node<E> n = this.first;
            if (n == null || n == NIL_NODE) {
                return;
            }
            this.ensureUnaliased();
            while (n != NIL_NODE) {
                Node<E> c = n;
                c.head = operator.apply(c.head);
                n = c.tail;
            }
        }

        @Override
        public final void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
            Node<E> node = this.first;
            if (node == null || node == NIL_NODE) {
                return;
            }
            this.ensureUnaliased();
            int i = 0;
            while (node != NIL_NODE) {
                node.head = operator.apply(i++, node.head);
                node = node.tail;
            }
        }

        @Override
        public final boolean retainAll(@NotNull Predicate<? super E> predicate) {
            Node<E> prev = null;
            Node<E> cur = this.first;
            if (cur == null) {
                return false;
            }
            this.ensureUnaliased();
            int oldLen = this.len;
            while (cur != NIL_NODE) {
                Node follow = cur.tail;
                if (!predicate.test(cur.head)) {
                    if (prev == null) {
                        this.first = follow;
                    } else {
                        prev.tail = follow;
                    }
                    --this.len;
                } else {
                    prev = cur;
                }
                cur = follow;
            }
            this.last = prev;
            return this.len != oldLen;
        }

        @Override
        public final void reverse() {
            if (this.len <= 1) {
                return;
            }
            MutableSinglyLinkedList<E> newBuilder = new MutableSinglyLinkedList<E>();
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                E e = iterator.next();
                newBuilder.prepend(e);
            }
            this.first = newBuilder.first;
            this.last = newBuilder.last;
            this.aliased = false;
        }
    }
}

