/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.immutable;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kala.collection.ArraySeq;
import kala.collection.Set;
import kala.collection.SortedSet;
import kala.collection.factory.CollectionFactory;
import kala.collection.immutable.AbstractImmutableCollection;
import kala.collection.immutable.AbstractImmutableSet;
import kala.collection.immutable.ImmutableAnySet;
import kala.collection.immutable.ImmutableCollection;
import kala.collection.immutable.ImmutableHashSet;
import kala.function.Predicates;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ImmutableSet<E>
extends ImmutableCollection<E>,
Set<E>,
ImmutableAnySet<E> {
    @Contract(value="_ -> param1", pure=true)
    public static <E> ImmutableSet<E> narrow(ImmutableSet<? extends E> set) {
        return set;
    }

    public static <E> CollectionFactory<E, ?, ? extends ImmutableSet<E>> factory() {
        return ImmutableHashSet.factory();
    }

    @NotNull
    public static <E> ImmutableSet<E> empty() {
        return ImmutableHashSet.empty();
    }

    @NotNull
    public static <E> ImmutableSet<E> of() {
        return ImmutableHashSet.of();
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E value1) {
        return ImmutableHashSet.of(value1);
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E value1, E value2) {
        return ImmutableHashSet.of(value1, value2);
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E value1, E value2, E value3) {
        return ImmutableHashSet.of(value1, value2, value3);
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E value1, E value2, E value3, E value4) {
        return ImmutableHashSet.of(value1, value2, value3, value4);
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E value1, E value2, E value3, E value4, E value5) {
        return ImmutableHashSet.of(value1, value2, value3, value4, value5);
    }

    @NotNull
    public static <E> ImmutableSet<E> of(E ... values) {
        return ImmutableHashSet.of(values);
    }

    @NotNull
    public static <E> ImmutableSet<E> from(E @NotNull [] values) {
        return ImmutableHashSet.from(values);
    }

    @NotNull
    public static <E> ImmutableSet<E> from(@NotNull Iterable<? extends E> values) {
        return ImmutableHashSet.from(values);
    }

    @NotNull
    public static <E> ImmutableSet<E> from(@NotNull Iterator<? extends E> it) {
        return ImmutableHashSet.from(it);
    }

    @NotNull
    public static <E> ImmutableSet<E> from(@NotNull Stream<? extends E> stream) {
        return ImmutableHashSet.from(stream);
    }

    @Override
    @NotNull
    default public String className() {
        return "ImmutableSet";
    }

    @Override
    @NotNull
    default public <U> CollectionFactory<U, ?, ? extends ImmutableSet<U>> iterableFactory() {
        return ImmutableSet.factory();
    }

    @NotNull
    default public ImmutableSet<E> added(E value) {
        if (this.contains(value)) {
            return this;
        }
        Object factory = this instanceof SortedSet ? ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator()) : this.iterableFactory();
        return AbstractImmutableSet.added(this, value, factory);
    }

    @NotNull
    default public ImmutableSet<E> addedAll(@NotNull Iterable<? extends E> values) {
        Object factory = this instanceof SortedSet ? ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator()) : this.iterableFactory();
        return AbstractImmutableSet.addedAll(this, values, factory);
    }

    @NotNull
    default public ImmutableSet<E> addedAll(E @NotNull [] values) {
        return this.addedAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
    }

    @NotNull
    default public ImmutableSet<E> removed(E value) {
        if (!this.contains(value)) {
            return this;
        }
        Object factory = this instanceof SortedSet ? ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator()) : this.iterableFactory();
        if (this.sizeIs(1)) {
            return (ImmutableSet)factory.empty();
        }
        return AbstractImmutableSet.removed(this, value, factory);
    }

    @NotNull
    default public ImmutableSet<E> removedAll(@NotNull Iterable<? extends E> values) {
        Object factory = this instanceof SortedSet ? ((SortedSet)((Object)this)).iterableFactory(((SortedSet)((Object)this)).comparator()) : this.iterableFactory();
        return AbstractImmutableSet.removedAll(this, values, factory);
    }

    @NotNull
    default public ImmutableSet<E> removedAll(E @NotNull [] values) {
        return this.removedAll((Iterable<? extends E>)((Object)ArraySeq.wrap(values)));
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filter(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filter(this, predicate, ImmutableSet.factory());
    }

    @Override
    @NotNull
    default public ImmutableSet<E> filterNot(@NotNull Predicate<? super E> predicate) {
        return AbstractImmutableCollection.filterNot(this, predicate, ImmutableSet.factory());
    }

    @Override
    @NotNull
    default public @NotNull ImmutableSet<@NotNull E> filterNotNull() {
        return this.filter(Predicates.isNotNull());
    }

    @Override
    @NotNull
    default public <U> ImmutableSet<U> filterIsInstance(@NotNull Class<? extends U> clazz) {
        return this.filter(clazz::isInstance);
    }
}

