/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.internal.tree;

import java.util.function.Consumer;
import kala.internal.ComparableUtils;
import org.jetbrains.annotations.NotNull;

public class BTree8<K> {
    static final int M = 8;
    static final int T = 4;
    static final int MAX_KEY_NUMBER = 7;
    static final int MIN_KEY_NUMBER = 3;
    private int size;
    private Node<K> root;

    protected int compare(K k0, K k1) {
        return ComparableUtils.compare(k0, k1);
    }

    protected int binarySearch(Node<K> node, K value) {
        byte n = node.n;
        int low = 0;
        int high = n - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = node.getKey(mid);
            int c = this.compare(midVal, value);
            if (c < 0) {
                low = mid + 1;
                continue;
            }
            if (c > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected void forEachKey(@NotNull Node<K> node, Consumer<? super K> action) {
        int n = node.n;
        if (node.isLeaf()) {
            for (int i = 0; i < n; ++i) {
                action.accept(node.getKey(i));
            }
        } else {
            this.forEachKey(node.getNode(0), action);
            for (int i = 0; i < n; ++i) {
                action.accept(node.getKey(i));
                this.forEachKey(node.getNode(i + 1), action);
            }
        }
    }

    protected Node<K> search(Node<K> node, K value) {
        int idx;
        while ((idx = this.binarySearch(node, value)) < 0) {
            if (node.isLeaf()) {
                return null;
            }
            node = node.getNode(-(idx + 1));
        }
        return node;
    }

    protected void insert(K key) {
        if (this.root == null) {
            Node node = new Node();
            node.k0 = key;
            node.n = 1;
            this.root = node;
        } else if (this.root.n == 7) {
            Node node = new Node();
            node.n0 = this.root;
            this.splitChild(node, this.root, 0);
            this.insertNonFull(node, key);
            this.root = node;
        } else {
            this.insertNonFull(this.root, key);
        }
        ++this.size;
    }

    protected boolean insertNonFull(Node<K> node, K key) {
        int idx = -(this.binarySearch(node, key) + 1);
        if (node.isLeaf()) {
            node.insertKey(idx, key);
            node.n = (byte)(node.n + 1);
        } else {
            Node<K> child = node.getNode(idx);
            if (child.n == 7) {
                this.splitChild(node, child, idx);
                if (this.compare(key, node.getKey(idx)) > 0) {
                    ++idx;
                }
            }
            this.insertNonFull(node.getNode(idx), key);
        }
        return true;
    }

    protected void splitChild(Node<K> parent, Node<K> child, int idx) {
        int i;
        Node<K> newChild = new Node<K>();
        newChild.n = (byte)3;
        for (i = 0; i < 3; ++i) {
            newChild.setKey(i, child.getKey(i + 4));
            child.setKey(i + 4, null);
        }
        if (!child.isLeaf()) {
            for (i = 0; i < 4; ++i) {
                newChild.setNode(i, child.getNode(i + 4));
                child.setNode(i + 4, null);
            }
        }
        child.n = (byte)3;
        parent.insertKey(idx, child.getKey(3));
        parent.insertNode(idx + 1, newChild);
        parent.n = (byte)(parent.n + 1);
    }

    public static final class Node<K> {
        byte n;
        K k0;
        K k1;
        K k2;
        K k3;
        K k4;
        K k5;
        K k6;
        Node<K> n0;
        Node<K> n1;
        Node<K> n2;
        Node<K> n3;
        Node<K> n4;
        Node<K> n5;
        Node<K> n6;
        Node<K> n7;

        K getKey(int idx) {
            switch (idx) {
                case 0: {
                    return this.k0;
                }
                case 1: {
                    return this.k1;
                }
                case 2: {
                    return this.k2;
                }
                case 3: {
                    return this.k3;
                }
                case 4: {
                    return this.k4;
                }
                case 5: {
                    return this.k5;
                }
                case 6: {
                    return this.k6;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        void setKey(int idx, K key) {
            switch (idx) {
                case 0: {
                    this.k0 = key;
                    break;
                }
                case 1: {
                    this.k1 = key;
                    break;
                }
                case 2: {
                    this.k2 = key;
                    break;
                }
                case 3: {
                    this.k3 = key;
                    break;
                }
                case 4: {
                    this.k4 = key;
                    break;
                }
                case 5: {
                    this.k5 = key;
                    break;
                }
                case 6: {
                    this.k6 = key;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        void insertKey(int idx, K key) {
            for (int i = 6; i > idx; --i) {
                this.setKey(i, this.getKey(i - 1));
            }
            this.setKey(idx, key);
        }

        void removeKey(int idx) {
            this.setKey(idx, null);
            for (int i = idx; i < 6; ++i) {
                this.setKey(idx, this.getKey(i + 1));
            }
            this.setKey(6, null);
        }

        Node<K> getNode(int idx) {
            switch (idx) {
                case 0: {
                    return this.n0;
                }
                case 1: {
                    return this.n1;
                }
                case 2: {
                    return this.n2;
                }
                case 3: {
                    return this.n3;
                }
                case 4: {
                    return this.n4;
                }
                case 5: {
                    return this.n5;
                }
                case 6: {
                    return this.n6;
                }
                case 7: {
                    return this.n7;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        void setNode(int idx, Node<K> node) {
            switch (idx) {
                case 0: {
                    this.n0 = node;
                    break;
                }
                case 1: {
                    this.n1 = node;
                    break;
                }
                case 2: {
                    this.n2 = node;
                    break;
                }
                case 3: {
                    this.n3 = node;
                    break;
                }
                case 4: {
                    this.n4 = node;
                    break;
                }
                case 5: {
                    this.n5 = node;
                    break;
                }
                case 6: {
                    this.n6 = node;
                    break;
                }
                case 7: {
                    this.n7 = node;
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException();
                }
            }
        }

        void insertNode(int idx, Node<K> node) {
            for (int i = 7; i > idx; --i) {
                this.setNode(i, this.getNode(i - 1));
            }
            this.setNode(idx, node);
        }

        public boolean isLeaf() {
            return this.n0 == null;
        }

        public String toString() {
            int i;
            StringBuilder res = new StringBuilder();
            res.append("{");
            res.append("\"n\": ").append(this.n).append(',');
            res.append("\"keys\": {");
            res.append("\"k0\"").append(": ").append(this.k0);
            for (i = 1; i < 7; ++i) {
                res.append(",\"k").append(i).append("\": ").append(this.getKey(i));
            }
            res.append("}");
            res.append(',');
            res.append("\"nodes\": {");
            res.append("\"n0\"").append(": ").append(this.n0);
            for (i = 1; i <= 7; ++i) {
                res.append(",\"n").append(i).append("\": ").append(this.getNode(i));
            }
            res.append("}");
            res.append("}");
            return res.toString();
        }
    }
}

