/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kala.Conditions;
import kala.collection.ArraySeq;
import kala.collection.base.GenericArrays;
import kala.collection.base.Traversable;
import kala.collection.factory.CollectionFactory;
import kala.collection.mutable.MutableArrayList;
import kala.collection.mutable.MutableArraySliceView;
import kala.collection.mutable.MutableSeq;
import kala.function.IndexedFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MutableArray<E>
extends ArraySeq<E>
implements MutableSeq<E>,
Serializable {
    private static final long serialVersionUID = 8060307722127719792L;
    public static final MutableArray<?> EMPTY = new MutableArray(GenericArrays.EMPTY_OBJECT_ARRAY);
    private static final Factory<?> FACTORY = new Factory();

    MutableArray(Object @NotNull [] array) {
        super(array);
    }

    @NotNull
    public static <E> CollectionFactory<E, ?, MutableArray<E>> factory() {
        return FACTORY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArray<E> create(int size) {
        return new MutableArray<E>(new Object[size]);
    }

    @NotNull
    public static <E> MutableArray<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> MutableArray<E> of() {
        return EMPTY;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static <E> MutableArray<E> of(E value1) {
        return new MutableArray<E>(new Object[]{value1});
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static <E> MutableArray<E> of(E value1, E value2) {
        return new MutableArray<E>(new Object[]{value1, value2});
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <E> MutableArray<E> of(E value1, E value2, E value3) {
        return new MutableArray<E>(new Object[]{value1, value2, value3});
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static <E> MutableArray<E> of(E value1, E value2, E value3, E value4) {
        return new MutableArray<E>(new Object[]{value1, value2, value3, value4});
    }

    @Contract(value="_, _, _, _, _ -> new")
    @NotNull
    public static <E> MutableArray<E> of(E value1, E value2, E value3, E value4, E value5) {
        return new MutableArray<E>(new Object[]{value1, value2, value3, value4, value5});
    }

    @NotNull
    public static <E> MutableArray<E> of(E ... values) {
        return MutableArray.from(values);
    }

    @NotNull
    public static <E> MutableArray<E> from(E @NotNull [] values) {
        int length = values.length;
        if (length == 0) {
            return MutableArray.empty();
        }
        Object[] newValues = new Object[length];
        System.arraycopy(values, 0, newValues, 0, length);
        return new MutableArray<E>(newValues);
    }

    @NotNull
    public static <E> MutableArray<E> from(@NotNull Traversable<? extends E> values) {
        return values.knownSize() == 0 ? MutableArray.empty() : new MutableArray<E>(values.toArray());
    }

    @NotNull
    public static <E> MutableArray<E> from(@NotNull Collection<? extends E> values) {
        return values.size() == 0 ? MutableArray.empty() : new MutableArray<E>(values.toArray());
    }

    @NotNull
    public static <E> MutableArray<E> from(@NotNull Iterable<? extends E> values) {
        Objects.requireNonNull(values);
        if (values instanceof Traversable) {
            return MutableArray.from((Traversable)values);
        }
        if (values instanceof Collection) {
            return MutableArray.from((Collection)values);
        }
        return MutableArray.from(values.iterator());
    }

    @NotNull
    public static <E> MutableArray<E> from(@NotNull Iterator<? extends E> it) {
        if (!it.hasNext()) {
            return MutableArray.empty();
        }
        MutableArrayList<E> buffer = new MutableArrayList<E>();
        while (it.hasNext()) {
            buffer.append(it.next());
        }
        return new MutableArray<E>(buffer.toArray());
    }

    @NotNull
    public static <E> MutableArray<E> from(@NotNull Stream<? extends E> stream) {
        return stream.collect(MutableArray.factory());
    }

    @NotNull
    public static <E> MutableArray<E> fill(int n, E value) {
        if (n <= 0) {
            return MutableArray.empty();
        }
        Object[] ans = new Object[n];
        if (value != null) {
            Arrays.fill(ans, value);
        }
        return new MutableArray<E>(ans);
    }

    @NotNull
    public static <E> MutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
        if (n <= 0) {
            return MutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = supplier.get();
        }
        return new MutableArray<E>(ans);
    }

    @NotNull
    public static <E> MutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
        if (n <= 0) {
            return MutableArray.empty();
        }
        Object[] ans = new Object[n];
        for (int i = 0; i < n; ++i) {
            ans[i] = init.apply(i);
        }
        return new MutableArray<E>(ans);
    }

    @NotNull
    public static <E> MutableArray<E> generateUntil(@NotNull Supplier<? extends E> supplier, @NotNull Predicate<? super E> predicate) {
        E value;
        MutableArrayList<E> builder = new MutableArrayList<E>();
        while (!predicate.test(value = supplier.get())) {
            builder.append(value);
        }
        return new MutableArray<E>(builder.toArray());
    }

    @NotNull
    public static <E> MutableArray<E> generateUntilNull(@NotNull Supplier<? extends @Nullable E> supplier) {
        E value;
        MutableArrayList<E> builder = new MutableArrayList<E>();
        while ((value = supplier.get()) != null) {
            builder.append(value);
        }
        return new MutableArray<E>(builder.toArray());
    }

    @NotNull
    public static <E> MutableArray<E> wrap(E @NotNull [] array) {
        Objects.requireNonNull(array);
        return new Checked(array);
    }

    @Override
    @NotNull
    public final String className() {
        return "MutableArray";
    }

    @Override
    @NotNull
    public final <U> CollectionFactory<U, ?, MutableArray<U>> iterableFactory() {
        return MutableArray.factory();
    }

    @Override
    @NotNull
    public MutableArray<E> clone() {
        return new MutableArray<E>((Object[])this.elements.clone());
    }

    public final Object @NotNull [] getArray() {
        return this.elements;
    }

    public boolean isChecked() {
        return false;
    }

    @Override
    public final void set(int index, E newValue) {
        try {
            this.elements[index] = newValue;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    @NotNull
    public final MutableArraySliceView<E> sliceView(int beginIndex, int endIndex) {
        Conditions.checkPositionIndices((int)beginIndex, (int)endIndex, (int)this.elements.length);
        return new MutableArraySliceView(this.elements, beginIndex, endIndex);
    }

    @Override
    public final void replaceAll(@NotNull Function<? super E, ? extends E> operator) {
        Object[] elements = this.elements;
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = operator.apply(elements[i]);
        }
    }

    @Override
    public final void replaceAllIndexed(@NotNull IndexedFunction<? super E, ? extends E> operator) {
        Object[] elements = this.elements;
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = operator.apply(i, elements[i]);
        }
    }

    @Override
    public final void sort(@NotNull Comparator<? super E> comparator) {
        Arrays.sort(this.elements, comparator);
    }

    private static final class Factory<E>
    implements CollectionFactory<E, MutableArrayList<E>, MutableArray<E>> {
        Factory() {
        }

        public MutableArray<E> from(E @NotNull [] values) {
            return MutableArray.from(values);
        }

        public MutableArray<E> from(@NotNull Iterable<? extends E> values) {
            return MutableArray.from(values);
        }

        @NotNull
        public MutableArray<E> from(@NotNull Iterator<? extends E> it) {
            return MutableArray.from(it);
        }

        public MutableArray<E> fill(int n, E value) {
            return MutableArray.fill(n, value);
        }

        public MutableArray<E> fill(int n, @NotNull Supplier<? extends E> supplier) {
            return MutableArray.fill(n, supplier);
        }

        public MutableArray<E> fill(int n, @NotNull IntFunction<? extends E> init) {
            return MutableArray.fill(n, init);
        }

        public MutableArrayList<E> newBuilder() {
            return new MutableArrayList();
        }

        public void addToBuilder(@NotNull MutableArrayList<E> buffer, E value) {
            buffer.append(value);
        }

        public void sizeHint(@NotNull MutableArrayList<E> buffer, int size) {
            buffer.sizeHint(size);
        }

        public MutableArrayList<E> mergeBuilder(@NotNull MutableArrayList<E> builder1, @NotNull MutableArrayList<E> builder2) {
            builder1.appendAll((Iterable<E>)((Object)builder2));
            return builder1;
        }

        public MutableArray<E> build(@NotNull MutableArrayList<E> buffer) {
            return new MutableArray(buffer.toArray());
        }
    }

    private static final class Checked<E>
    extends MutableArray<E> {
        private static final long serialVersionUID = 3903230112786321463L;

        Checked(Object @NotNull [] array) {
            super(array);
        }

        @Override
        public boolean isChecked() {
            return true;
        }

        @Override
        @NotNull
        public MutableArray<E> clone() {
            return new Checked<E>((Object[])this.elements.clone());
        }
    }
}

