/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Comparator;
import java.util.function.Function;
import java.util.function.Predicate;
import kala.collection.mutable.MutableList;
import kala.collection.mutable.MutableSeqEditor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MutableListEditor<E, C extends MutableList<E>>
extends MutableSeqEditor<E, C> {
    protected MutableListEditor(@NotNull C source) {
        super(source);
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> append(E value) {
        ((MutableList)this.source).append(value);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> appendAll(@NotNull Iterable<? extends E> collection) {
        ((MutableList)this.source).appendAll(collection);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> appendAll(E @NotNull [] collection) {
        ((MutableList)this.source).appendAll(collection);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> prepend(E value) {
        ((MutableList)this.source).prepend(value);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> prependAll(@NotNull Iterable<? extends E> collection) {
        ((MutableList)this.source).prependAll(collection);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> prependAll(E @NotNull [] collection) {
        ((MutableList)this.source).prependAll(collection);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableListEditor<E, C> insert(int index, E element) {
        ((MutableList)this.source).insert(index, element);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableListEditor<E, C> insertAll(int index, @NotNull Iterable<? extends E> values) {
        ((MutableList)this.source).insertAll(index, values);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public MutableListEditor<E, C> insertAll(int index, E @NotNull [] values) {
        ((MutableList)this.source).insertAll(index, values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> removeAt(int index) {
        ((MutableList)this.source).removeAt(index);
        return this;
    }

    @Contract(value="-> this")
    @NotNull
    public MutableListEditor<E, C> removeFirst() {
        ((MutableList)this.source).removeFirst();
        return this;
    }

    @Contract(value="-> this")
    @NotNull
    public MutableListEditor<E, C> clear() {
        ((MutableList)this.source).clear();
        return this;
    }

    @Contract(value="_ -> this")
    public MutableListEditor<E, C> removeIf(@NotNull Predicate<? super E> predicate) {
        ((MutableList)this.source).removeIf(predicate);
        return this;
    }

    @Contract(value="_ -> this")
    public MutableListEditor<E, C> retainIf(@NotNull Predicate<? super E> predicate) {
        ((MutableList)this.source).retainIf(predicate);
        return this;
    }

    @Contract(value="_ -> this")
    public MutableListEditor<E, C> dropInPlace(int n) {
        ((MutableList)this.source).dropInPlace(n);
        return this;
    }

    @Contract(value="_ -> this")
    public MutableListEditor<E, C> takeInPlace(int n) {
        ((MutableList)this.source).takeInPlace(n);
        return this;
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public MutableListEditor<E, C> set(int index, E newValue) {
        ((MutableList)this.source).set(index, newValue);
        return this;
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public MutableListEditor<E, C> swap(int index1, int index2) {
        ((MutableList)this.source).swap(index1, index2);
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> replaceAll(@NotNull Function<? super E, ? extends E> mapper) {
        ((MutableList)this.source).replaceAll(mapper);
        return this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public MutableListEditor<E, C> sort() {
        ((MutableList)this.source).sort();
        return this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public MutableListEditor<E, C> sort(@NotNull Comparator<? super E> comparator) {
        ((MutableList)this.source).sort(comparator);
        return this;
    }
}

