/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import kala.collection.mutable.MutableCollection;
import kala.collection.mutable.MutableLinkedList;
import kala.control.Option;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MutableQueue<E>
extends MutableCollection<E> {
    @Contract(value="-> new")
    public static <E> MutableQueue<E> create() {
        return new MutableLinkedList();
    }

    @NotNull
    public static <E> MutableQueue<E> wrapJava(final @NotNull Queue<E> queue) {
        Objects.requireNonNull(queue);
        return new MutableQueue<E>(){

            @Override
            @NotNull
            public MutableCollection<E> clone() {
                return MutableCollection.from(queue);
            }

            @NotNull
            public Iterator<E> iterator() {
                return queue.iterator();
            }

            @Override
            public boolean isEmpty() {
                return queue.isEmpty();
            }

            @Override
            public void enqueue(E value) {
                queue.add(value);
            }

            @Override
            @NotNull
            public Option<E> dequeueOption() {
                return queue.isEmpty() ? Option.none() : Option.some(queue.remove());
            }
        };
    }

    @Override
    @NotNull
    default public String className() {
        return "MutableQueue";
    }

    public boolean isEmpty();

    public void enqueue(E var1);

    default public E dequeue() {
        return (E)this.dequeueOption().get();
    }

    @Nullable
    default public E dequeueOrNull() {
        return (E)this.dequeueOption().getOrNull();
    }

    @NotNull
    public Option<E> dequeueOption();
}

