/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.util.function.Predicate;
import kala.collection.mutable.MutableCollectionEditor;
import kala.collection.mutable.MutableSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MutableSetEditor<E, C extends MutableSet<E>>
extends MutableCollectionEditor<E, C> {
    public MutableSetEditor(@NotNull C source) {
        super(source);
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> add(E value) {
        ((MutableSet)this.source).add(value);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> addAll(@NotNull Iterable<? extends E> values) {
        ((MutableSet)this.source).addAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> addAll(E @NotNull [] values) {
        ((MutableSet)this.source).addAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> remove(E value) {
        ((MutableSet)this.source).remove(value);
        return this;
    }

    @Contract(value="-> this")
    @NotNull
    public MutableSetEditor<E, C> clear() {
        ((MutableSet)this.source).clear();
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> removeAll(@NotNull Iterable<? super E> values) {
        ((MutableSet)this.source).removeAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> removeAll(E @NotNull [] values) {
        ((MutableSet)this.source).removeAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> removeIf(@NotNull Predicate<? super E> predicate) {
        ((MutableSet)this.source).removeIf(predicate);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> retainAll(@NotNull Iterable<? super E> values) {
        ((MutableSet)this.source).retainAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> retainAll(E @NotNull [] values) {
        ((MutableSet)this.source).retainAll(values);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public MutableSetEditor<E, C> retainIf(@NotNull Predicate<? super E> predicate) {
        ((MutableSet)this.source).retainIf(predicate);
        return this;
    }
}

