/*
 * Decompiled with CFR 0.152.
 */
package kala.collection.mutable;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import kala.collection.MapLike;
import kala.collection.SortedMap;
import kala.collection.base.AbstractIterator;
import kala.collection.base.AbstractMapIterator;
import kala.collection.base.Iterators;
import kala.collection.base.MapIterator;
import kala.collection.factory.MapFactory;
import kala.collection.internal.convert.AsJavaConvert;
import kala.collection.internal.tree.RedBlackTree;
import kala.collection.mutable.AbstractMutableMapFactory;
import kala.collection.mutable.MutableMap;
import kala.collection.mutable.MutableMapEditor;
import kala.control.Option;
import kala.internal.ComparableUtils;
import kala.internal.InternalIdentifyObject;
import kala.tuple.Tuple2;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Debug.Renderer(hasChildren="isNotEmpty()", childrenArray="toArray()")
public final class MutableTreeMap<K, V>
extends RedBlackTree<K, Node<K, V>>
implements MutableMap<K, V>,
SortedMap<K, V>,
Serializable {
    private static final long serialVersionUID = 5474475537398882423L;
    private static final Factory<?, ?> DEFAULT_FACTORY = new Factory(null);
    private static final Object NONE_HOLE = new InternalIdentifyObject();

    public MutableTreeMap() {
        this((Comparator<K>)null);
    }

    public MutableTreeMap(Comparator<? super K> comparator) {
        super(comparator);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MapFactory<K, V, ?, MutableTreeMap<K, V>> factory() {
        return DEFAULT_FACTORY;
    }

    @NotNull
    public static <K, V> MapFactory<K, V, ?, MutableTreeMap<K, V>> factory(Comparator<? super K> comparator) {
        return comparator == null ? DEFAULT_FACTORY : new Factory(comparator);
    }

    @NotNull
    static <T, K extends Comparable<? super K>, V> Collector<T, ?, MutableTreeMap<K, V>> collector(@NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(MutableTreeMap.factory(), keyMapper, valueMapper);
    }

    @NotNull
    static <T, K, V> Collector<T, ?, MutableTreeMap<K, V>> collector(Comparator<? super K> comparator, @NotNull Function<? super T, ? extends K> keyMapper, @NotNull Function<? super T, ? extends V> valueMapper) {
        return MapFactory.collector(MutableTreeMap.factory(comparator), keyMapper, valueMapper);
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of() {
        return new MutableTreeMap<K, V>();
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of(K k1, V v1) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.set(k1, v1);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of(K k1, V v1, K k2, V v2) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        m.set(k5, v5);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator) {
        return new MutableTreeMap<K, V>(comparator);
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator, K k1, V v1) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        m.set(k1, v1);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        m.set(k1, v1);
        m.set(k2, v2);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> of(Comparator<? super K> comparator, K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        m.set(k1, v1);
        m.set(k2, v2);
        m.set(k3, v3);
        m.set(k4, v4);
        m.set(k5, v5);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries() {
        return new MutableTreeMap<K, V>();
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        res.set(entry1);
        return res;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        return res;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        return res;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        return res;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(@NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        res.set(entry5);
        return res;
    }

    @SafeVarargs
    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> ofEntries(Tuple2<? extends K, ? extends V> ... entries) {
        MutableTreeMap<K, V> res = new MutableTreeMap<K, V>();
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            res.set(entry);
        }
        return res;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator) {
        return new MutableTreeMap<K, V>(comparator);
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, @NotNull Tuple2<? extends K, ? extends V> entry1) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        res.set(entry1);
        return res;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, @NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        res.set(entry1);
        res.set(entry2);
        return res;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, @NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        return res;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, @NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        return res;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, @NotNull Tuple2<? extends K, ? extends V> entry1, @NotNull Tuple2<? extends K, ? extends V> entry2, @NotNull Tuple2<? extends K, ? extends V> entry3, @NotNull Tuple2<? extends K, ? extends V> entry4, @NotNull Tuple2<? extends K, ? extends V> entry5) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        res.set(entry1);
        res.set(entry2);
        res.set(entry3);
        res.set(entry4);
        res.set(entry5);
        return res;
    }

    @SafeVarargs
    @NotNull
    public static <K, V> MutableTreeMap<K, V> ofEntries(Comparator<? super K> comparator, Tuple2<? extends K, ? extends V> ... entries) {
        MutableTreeMap<? super K, V> res = new MutableTreeMap<K, V>(comparator);
        for (Tuple2<? extends K, ? extends V> entry : entries) {
            res.set(entry);
        }
        return res;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> from(@NotNull Map<? extends K, ? extends V> values) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> from(@NotNull MapLike<? extends K, ? extends V> values) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>();
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> from(@NotNull java.util.SortedMap<? extends K, ? extends V> values) {
        MutableTreeMap<? extends K, V> m = new MutableTreeMap<K, V>(values.comparator());
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> from(@NotNull SortedMap<? extends K, ? extends V> values) {
        MutableTreeMap<? extends K, V> m = new MutableTreeMap<K, V>(values.comparator());
        m.putAll(values);
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> from(Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        MutableTreeMap<Comparable, V> m = new MutableTreeMap<Comparable, V>();
        for (Map.Entry<K, V> entry : values) {
            m.set((Comparable)entry.getKey(), entry.getValue());
        }
        return m;
    }

    @NotNull
    public static <K extends Comparable<? super K>, V> MutableTreeMap<K, V> from(@NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        MutableTreeMap<Comparable, V> m = new MutableTreeMap<Comparable, V>();
        for (Map.Entry<K, V> value : values) {
            m.set((Comparable)value.getKey(), value.getValue());
        }
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> from(Comparator<? super K> comparator, Map.Entry<? extends K, ? extends V> @NotNull [] values) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        for (Map.Entry<K, V> entry : values) {
            m.set(entry.getKey(), entry.getValue());
        }
        return m;
    }

    @NotNull
    public static <K, V> MutableTreeMap<K, V> from(Comparator<? super K> comparator, @NotNull Iterable<? extends Map.Entry<? extends K, ? extends V>> values) {
        MutableTreeMap<K, V> m = new MutableTreeMap<K, V>(comparator);
        for (Map.Entry<K, V> value : values) {
            m.set(value.getKey(), value.getValue());
        }
        return m;
    }

    @Override
    @NotNull
    public String className() {
        return "MutableTreeMap";
    }

    @Override
    @NotNull
    public <NK, NV> MapFactory<NK, NV, ?, MutableTreeMap<NK, NV>> mapFactory() {
        return (Factory)MutableTreeMap.factory();
    }

    @Override
    @NotNull
    public <NK, NV> MapFactory<NK, NV, ?, MutableTreeMap<NK, NV>> mapFactory(Comparator<? super NK> comparator) {
        return MutableTreeMap.factory(comparator);
    }

    @Override
    @NotNull
    public MapIterator<K, V> iterator() {
        Node node = (Node)this.firstNode();
        return node == null ? MapIterator.empty() : new Itr(node);
    }

    @Override
    @NotNull
    public MutableMapEditor<K, V, MutableTreeMap<K, V>> edit() {
        return new MutableMapEditor(this);
    }

    @Override
    @NotNull
    public Map<K, V> asJava() {
        return new AsJava(this);
    }

    @Override
    public V get(K key) {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            throw new NoSuchElementException();
        }
        return node.value;
    }

    @Override
    @Nullable
    public V getOrNull(K key) {
        Node node = (Node)this.getNode(key);
        return node == null ? null : (V)node.value;
    }

    @Override
    @NotNull
    public Option<V> getOption(K key) {
        Node node = (Node)this.getNode(key);
        return node == null ? Option.none() : Option.some(node.value);
    }

    @Override
    public V getOrDefault(K key, V defaultValue) {
        Node node = (Node)this.getNode(key);
        return node == null ? defaultValue : node.value;
    }

    @Override
    public V getOrElse(K key, @NotNull Supplier<? extends V> supplier) {
        Node node = (Node)this.getNode(key);
        return node == null ? supplier.get() : node.value;
    }

    @Override
    public V getOrPut(K key, @NotNull Supplier<? extends V> defaultValue) {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            V dv = defaultValue.get();
            this.set(key, dv);
            return dv;
        }
        return node.value;
    }

    @Override
    public <Ex extends Throwable> V getOrThrow(K key, @NotNull Supplier<? extends Ex> supplier) throws Ex {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            throw (Throwable)supplier.get();
        }
        return node.value;
    }

    @Override
    public <Ex extends Throwable> V getOrThrowException(K key, @NotNull Ex exception) throws Ex {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            throw exception;
        }
        return node.value;
    }

    private Object put0(K key, V value) {
        int c;
        Node parent;
        Comparator comparator = this.comparator;
        Node node = (Node)this.root;
        if (node == null) {
            this.root = new Node<K, V>(key, value, null);
            this.size = 1;
            return NONE_HOLE;
        }
        if (comparator == null) {
            do {
                parent = node;
                c = ComparableUtils.compare(key, (Object)node.key);
                if (c < 0) {
                    node = (Node)node.left;
                    continue;
                }
                if (c > 0) {
                    node = (Node)node.right;
                    continue;
                }
                Object oldValue = node.value;
                node.value = value;
                return oldValue;
            } while (node != null);
        } else {
            do {
                parent = node;
                c = comparator.compare(key, node.key);
                if (c < 0) {
                    node = (Node)node.left;
                    continue;
                }
                if (c > 0) {
                    node = (Node)node.right;
                    continue;
                }
                Object oldValue = node.value;
                node.value = value;
                return oldValue;
            } while (node != null);
        }
        Node<K, V> n = new Node<K, V>(key, value, parent);
        if (c < 0) {
            parent.left = n;
        } else {
            parent.right = n;
        }
        ++this.size;
        this.fixAfterInsert(n);
        return NONE_HOLE;
    }

    @Override
    public void set(K key, V value) {
        this.put0(key, value);
    }

    @Override
    @NotNull
    public Option<V> put(K key, V value) {
        Object res = this.put0(key, value);
        return res != NONE_HOLE ? Option.some((Object)res) : Option.none();
    }

    @Override
    @NotNull
    public Option<V> remove(K key) {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            return Option.none();
        }
        Object oldValue = node.value;
        this.remove0(node);
        return Option.some(oldValue);
    }

    @Override
    @NotNull
    public Option<V> replace(K key, V value) {
        Node node = (Node)this.getNode(key);
        if (node == null) {
            return Option.none();
        }
        Object oldValue = node.value;
        node.value = value;
        return Option.some(oldValue);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Node node = (Node)this.getNode(key);
        if (node == null || !Objects.equals(node.value, oldValue)) {
            return false;
        }
        node.value = newValue;
        return true;
    }

    @Override
    public void replaceAll(@NotNull BiFunction<? super K, ? super V, ? extends V> function) {
        Node node = (Node)this.root;
        while (node != null) {
            Node n;
            node.value = function.apply(node.key, node.value);
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            node = n;
        }
    }

    @Override
    public K firstKey() {
        Node node = (Node)this.firstNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return (K)node.key;
    }

    @Override
    public K lastKey() {
        Node node = (Node)this.lastNode();
        if (node == null) {
            throw new NoSuchElementException();
        }
        return (K)node.key;
    }

    public String toString() {
        return this.className() + '{' + this.joinToString() + '}';
    }

    @Override
    public void forEach(@NotNull BiConsumer<? super K, ? super V> consumer) {
        Node node = (Node)this.root;
        while (node != null) {
            Node n;
            consumer.accept(node.key, node.value);
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            node = n;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        this.forEachUnchecked((k, v) -> {
            s.writeObject(k);
            s.writeObject(v);
        });
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object k = s.readObject();
            Object v = s.readObject();
            this.set(k, v);
        }
    }

    private static final class Factory<K, V>
    extends AbstractMutableMapFactory<K, V, MutableTreeMap<K, V>> {
        private final Comparator<? super K> comparator;

        Factory(Comparator<? super K> comparator) {
            this.comparator = comparator;
        }

        public MutableTreeMap<K, V> newBuilder() {
            return new MutableTreeMap(this.comparator);
        }
    }

    static final class Node<K, V>
    extends RedBlackTree.Node<K, Node<K, V>>
    implements Map.Entry<K, V> {
        V value;

        public Node(K key, V value, Node<K, V> parent) {
            super(key, parent);
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return (K)this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public void copyValuesFrom(Node<K, V> other) {
            this.key = other.key;
            this.value = other.value;
        }
    }

    static final class Itr<K, V>
    extends AbstractMapIterator<K, V> {
        private Node<K, V> node;
        private V value;

        Itr(Node<K, V> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public K nextKey() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            this.value = node.value;
            return (K)node.key;
        }

        public V getValue() {
            return this.value;
        }
    }

    static final class AsJava<K, V>
    extends AsJavaConvert.MutableMapAsJava<K, V, MutableTreeMap<K, V>> {
        AsJava(MutableTreeMap<K, V> source) {
            super(source);
        }

        @Override
        @NotNull
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet((MutableTreeMap)this.source);
        }

        static final class EntrySet<K, V>
        extends AsJavaConvert.MapAsJava.EntrySet<K, V, MutableTreeMap<K, V>> {
            EntrySet(MutableTreeMap<K, V> source) {
                super(source);
            }

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return ((MutableTreeMap)this.source).root == null ? Iterators.empty() : new NodeItr((Node)((MutableTreeMap)this.source).root);
            }
        }
    }

    static final class NodeItr<K, V>
    extends AbstractIterator<Node<K, V>> {
        private Node<K, V> node;

        NodeItr(Node<K, V> node) {
            this.node = node;
        }

        public boolean hasNext() {
            return this.node != null;
        }

        public Node<K, V> next() {
            Node n;
            Node node = this.node;
            if (node == null) {
                throw new NoSuchElementException();
            }
            if (node.right != null) {
                n = (Node)node.right;
                while (n.left != null) {
                    n = (Node)n.left;
                }
            } else {
                n = (Node)node.parent;
                Node c = node;
                while (n != null && c == n.right) {
                    c = n;
                    n = (Node)n.parent;
                }
            }
            this.node = n;
            return node;
        }
    }
}

