/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.archivers.tar;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kala.compress.archivers.ArchiveInputStream;
import kala.compress.archivers.ArchiveOutputStream;
import kala.compress.archivers.ArchiveStreamFactory;
import kala.compress.archivers.tar.TarArchiveEntry;
import kala.compress.archivers.tar.TarArchiveInputStream;
import kala.compress.archivers.tar.TarArchiveOutputStream;

final class TarArchiver
extends ArchiveStreamFactory.BuiltinArchiver {
    private static final int TAR_TEST_ENTRY_COUNT = 10;

    public TarArchiver() {
        super("tar");
    }

    public boolean matches(byte[] signature, int length) {
        return TarArchiveInputStream.matches(signature, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkTarChecksum(byte[] tarHeader) {
        try (TarArchiveInputStream inputStream = new TarArchiveInputStream(new ByteArrayInputStream(tarHeader));){
            TarArchiveEntry entry = inputStream.getNextEntry();
            int count = 0;
            while (entry != null && entry.isDirectory() && entry.isCheckSumOK() && count++ < 10) {
                entry = inputStream.getNextEntry();
            }
            if (entry == null || !entry.isCheckSumOK() || entry.isDirectory() || entry.getSize() <= 0L) {
                if (count <= 0) return false;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public ArchiveInputStream<?> createArchiveInputStream(InputStream in, Charset charset) {
        return new TarArchiveInputStream(in, charset);
    }

    public boolean isOutputAvailable() {
        return true;
    }

    public ArchiveOutputStream<?> createArchiveOutputStream(OutputStream out, Charset charset) {
        return new TarArchiveOutputStream(out, charset);
    }
}

