/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.archivers;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import kala.compress.archivers.ArchiveEntry;
import kala.compress.function.IOConsumer;
import kala.compress.function.IOIterator;

public abstract class ArchiveInputStream<E extends ArchiveEntry>
extends FilterInputStream {
    private static final int BYTE_MASK = 255;
    private final byte[] single = new byte[1];
    private long bytesRead;
    protected final Charset encoding;

    protected ArchiveInputStream(InputStream inputStream, Charset encoding) {
        super(inputStream);
        this.encoding = encoding;
    }

    public boolean canReadEntryData(ArchiveEntry archiveEntry) {
        return true;
    }

    protected void count(int read) {
        this.count((long)read);
    }

    protected void count(long read) {
        if (read != -1L) {
            this.bytesRead += read;
        }
    }

    public void forEach(IOConsumer<? super E> action) throws IOException {
        this.iterator().forEachRemaining(Objects.requireNonNull(action));
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public abstract E getNextEntry() throws IOException;

    public IOIterator<E> iterator() {
        return new ArchiveEntryIOIterator();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    protected void pushedBackBytes(long pushedBack) {
        this.bytesRead -= pushedBack;
    }

    @Override
    public int read() throws IOException {
        int num = this.read(this.single, 0, 1);
        return num == -1 ? -1 : this.single[0] & 0xFF;
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    class ArchiveEntryIOIterator
    implements IOIterator<E> {
        private E next;

        ArchiveEntryIOIterator() {
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.next == null) {
                this.next = ArchiveInputStream.this.getNextEntry();
            }
            return this.next != null;
        }

        @Override
        public E next() throws IOException {
            if (this.next != null) {
                Object e = this.next;
                this.next = null;
                return e;
            }
            return ArchiveInputStream.this.getNextEntry();
        }
    }
}

