/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.archivers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import kala.compress.archivers.ArchiveEntry;
import kala.compress.archivers.ArchiveException;
import kala.compress.archivers.ArchiveInputStream;
import kala.compress.archivers.ArchiveOutputStream;
import kala.compress.archivers.ArchiveStreamProvider;
import kala.compress.archivers.StreamingNotSupportedException;
import kala.compress.utils.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ArchiveStreamFactory
implements ArchiveStreamProvider {
    private static final int TAR_HEADER_SIZE = 512;
    private static final int DUMP_SIGNATURE_SIZE = 32;
    private static final int SIGNATURE_SIZE = 12;
    public static final String APK = "apk";
    public static final String XAPK = "xapk";
    public static final String APKS = "apks";
    public static final String APKM = "apkm";
    public static final String AR = "ar";
    public static final String ARJ = "arj";
    public static final String CPIO = "cpio";
    public static final String DUMP = "dump";
    public static final String JAR = "jar";
    public static final String TAR = "tar";
    public static final String ZIP = "zip";
    public static final String SEVEN_Z = "7z";
    private static final Map<String, BuiltinArchiver> BUILTIN_ARCHIVERS = new LinkedHashMap<String, BuiltinArchiver>();
    private static final Set<String> ALL_NAMES;
    private static final Set<String> OUTPUT_NAMES;
    private static final BuiltinArchiver TAR_ARCHIVER;
    private static final BuiltinArchiver DUMP_ARCHIVER;
    public static final ArchiveStreamFactory DEFAULT;
    private final Charset entryEncoding;
    private final SortedMap<String, ArchiveStreamProvider> archiveInputStreamProviders = new TreeMap<String, ArchiveStreamProvider>();
    private final SortedMap<String, ArchiveStreamProvider> archiveOutputStreamProviders = new TreeMap<String, ArchiveStreamProvider>();
    private final Set<String> inputStreamArchiveNames = new HashSet<String>(ALL_NAMES);
    private final Set<String> outputStreamArchiveNames = new HashSet<String>(OUTPUT_NAMES);

    private static BuiltinArchiver loadArchiver(List<BuiltinArchiver> archivers, String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ignored) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            BuiltinArchiver archiver = (BuiltinArchiver)constructor.newInstance(new Object[0]);
            archivers.add(archiver);
            return archiver;
        }
        catch (Throwable e) {
            throw new LinkageError(null, e);
        }
    }

    public static String detect(InputStream in) throws ArchiveException {
        if (in == null) {
            throw new IllegalArgumentException("Stream must not be null.");
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("Mark is not supported.");
        }
        byte[] signature = new byte[12];
        in.mark(signature.length);
        int signatureLength = -1;
        try {
            signatureLength = IOUtils.readFully(in, signature);
            in.reset();
        }
        catch (IOException e) {
            throw new ArchiveException("Failure reading signature.", e);
        }
        for (BuiltinArchiver archiver : BUILTIN_ARCHIVERS.values()) {
            if (!archiver.matches(signature, signatureLength)) continue;
            return archiver.getName();
        }
        if (DUMP_ARCHIVER != null) {
            byte[] dumpsig = new byte[32];
            in.mark(dumpsig.length);
            try {
                signatureLength = IOUtils.readFully(in, dumpsig);
                in.reset();
            }
            catch (IOException e) {
                throw new ArchiveException("IOException while reading dump signature", e);
            }
            if (DUMP_ARCHIVER.matches(dumpsig, signatureLength)) {
                return DUMP;
            }
        }
        if (TAR_ARCHIVER != null) {
            byte[] tarHeader = new byte[512];
            in.mark(tarHeader.length);
            try {
                signatureLength = IOUtils.readFully(in, tarHeader);
                in.reset();
            }
            catch (IOException e) {
                throw new ArchiveException("IOException while reading tar signature", e);
            }
            if (TAR_ARCHIVER.matches(tarHeader, signatureLength)) {
                return TAR;
            }
            if (signatureLength >= 512 && TAR_ARCHIVER.checkTarChecksum(tarHeader)) {
                return TAR;
            }
        }
        throw new ArchiveException("No Archiver found for the stream signature");
    }

    private static String toKey(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public ArchiveStreamFactory() {
        this(null);
    }

    public ArchiveStreamFactory(@Nullable Charset entryEncoding) {
        this.entryEncoding = entryEncoding;
    }

    public <I extends ArchiveInputStream<? extends ArchiveEntry>> I createArchiveInputStream(InputStream in) throws ArchiveException {
        return this.createArchiveInputStream(ArchiveStreamFactory.detect(in), in);
    }

    public <I extends ArchiveInputStream<? extends ArchiveEntry>> I createArchiveInputStream(String archiverName, InputStream in) throws ArchiveException {
        return this.createArchiveInputStream(archiverName, in, this.entryEncoding);
    }

    @Override
    public <I extends ArchiveInputStream<? extends ArchiveEntry>> I createArchiveInputStream(String archiverName, InputStream in, Charset actualEncoding) throws ArchiveException {
        if (archiverName == null) {
            throw new IllegalArgumentException("Archiver name must not be null.");
        }
        if (in == null) {
            throw new IllegalArgumentException("InputStream must not be null.");
        }
        BuiltinArchiver archiver = BUILTIN_ARCHIVERS.get(archiverName.toLowerCase(Locale.ROOT));
        if (archiver != null) {
            return (I)archiver.createArchiveInputStream(in, actualEncoding);
        }
        ArchiveStreamProvider archiveStreamProvider = (ArchiveStreamProvider)this.getArchiveInputStreamProviders().get(ArchiveStreamFactory.toKey(archiverName));
        if (archiveStreamProvider != null && !(archiveStreamProvider instanceof ArchiveStreamFactory)) {
            return archiveStreamProvider.createArchiveInputStream(archiverName, in, actualEncoding);
        }
        throw new ArchiveException("Archiver: " + archiverName + " not found.");
    }

    public <O extends ArchiveOutputStream<? extends ArchiveEntry>> O createArchiveOutputStream(String archiverName, OutputStream out) throws ArchiveException {
        return this.createArchiveOutputStream(archiverName, out, this.entryEncoding);
    }

    @Override
    public <O extends ArchiveOutputStream<? extends ArchiveEntry>> O createArchiveOutputStream(String archiverName, OutputStream out, Charset actualEncoding) throws ArchiveException {
        if (archiverName == null) {
            throw new IllegalArgumentException("Archiver name must not be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("OutputStream must not be null.");
        }
        BuiltinArchiver archiver = BUILTIN_ARCHIVERS.get(archiverName.toLowerCase(Locale.ROOT));
        if (archiver != null) {
            return (O)archiver.createArchiveOutputStream(out, actualEncoding);
        }
        ArchiveStreamProvider archiveStreamProvider = (ArchiveStreamProvider)this.getArchiveOutputStreamProviders().get(ArchiveStreamFactory.toKey(archiverName));
        if (archiveStreamProvider != null && !(archiveStreamProvider instanceof ArchiveStreamFactory)) {
            return archiveStreamProvider.createArchiveOutputStream(archiverName, out, actualEncoding);
        }
        throw new ArchiveException("Archiver: " + archiverName + " not found.");
    }

    public SortedMap<String, ArchiveStreamProvider> getArchiveInputStreamProviders() {
        return Collections.unmodifiableSortedMap(this.archiveInputStreamProviders);
    }

    public SortedMap<String, ArchiveStreamProvider> getArchiveOutputStreamProviders() {
        return Collections.unmodifiableSortedMap(this.archiveOutputStreamProviders);
    }

    public Charset getEntryEncoding() {
        return this.entryEncoding;
    }

    @Override
    public Set<String> getInputStreamArchiveNames() {
        return Collections.unmodifiableSet(this.inputStreamArchiveNames);
    }

    @Override
    public Set<String> getOutputStreamArchiveNames() {
        return Collections.unmodifiableSet(this.outputStreamArchiveNames);
    }

    @ApiStatus.Experimental
    public ArchiveStreamFactory withInstalledProviders() {
        return this.withProviders(ServiceLoader.load(ArchiveStreamProvider.class));
    }

    @ApiStatus.Experimental
    public ArchiveStreamFactory withInstalledProviders(ClassLoader classLoader) {
        return this.withProviders(ServiceLoader.load(ArchiveStreamProvider.class, classLoader));
    }

    @ApiStatus.Experimental
    public ArchiveStreamFactory withProviders(Iterable<? extends ArchiveStreamProvider> providers) {
        ArchiveStreamFactory result = new ArchiveStreamFactory(this.entryEncoding);
        for (ArchiveStreamProvider archiveStreamProvider : providers) {
            for (String name : archiveStreamProvider.getInputStreamArchiveNames()) {
                result.archiveInputStreamProviders.put(ArchiveStreamFactory.toKey(name), archiveStreamProvider);
                result.inputStreamArchiveNames.add(name);
            }
            for (String name : archiveStreamProvider.getOutputStreamArchiveNames()) {
                result.archiveOutputStreamProviders.put(ArchiveStreamFactory.toKey(name), archiveStreamProvider);
                result.outputStreamArchiveNames.add(name);
            }
        }
        return result;
    }

    static {
        String className = ArchiveStreamFactory.class.getName();
        String packagePrefix = className.substring(0, className.lastIndexOf(".") + 1);
        ArrayList<BuiltinArchiver> archivers = new ArrayList<BuiltinArchiver>();
        TAR_ARCHIVER = ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "tar.TarArchiver");
        DUMP_ARCHIVER = ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "dump.DumpArchiver");
        ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "zip.ZipArchiver");
        BuiltinArchiver jarArchiver = ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "jar.JarArchiver");
        ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "ar.ArArchiver");
        ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "arj.ArjArchiver");
        ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "cpio.CpioArchiver");
        ArchiveStreamFactory.loadArchiver(archivers, packagePrefix + "sevenz.SevenZArchiver");
        HashSet<String> archiverNames = new HashSet<String>();
        HashSet<String> outputArchiverNames = new HashSet<String>();
        for (BuiltinArchiver archiver : archivers) {
            BUILTIN_ARCHIVERS.put(archiver.getName(), archiver);
            archiverNames.add(archiver.getName());
            if (!archiver.isOutputAvailable()) continue;
            outputArchiverNames.add(archiver.getName());
        }
        if (jarArchiver != null) {
            BUILTIN_ARCHIVERS.put(APK, jarArchiver);
        }
        ALL_NAMES = Collections.unmodifiableSet(archiverNames);
        OUTPUT_NAMES = Collections.unmodifiableSet(outputArchiverNames);
        DEFAULT = new ArchiveStreamFactory();
    }

    @ApiStatus.Internal
    public static abstract class BuiltinArchiver {
        private final String name;

        protected BuiltinArchiver(String name) {
            this.name = name;
        }

        public final String getName() {
            return this.name;
        }

        public boolean matches(byte[] signature, int length) {
            return false;
        }

        public boolean checkTarChecksum(byte[] bytes) {
            throw new UnsupportedOperationException("checkChecksum");
        }

        public ArchiveInputStream<?> createArchiveInputStream(InputStream in, Charset charset) throws ArchiveException {
            throw new StreamingNotSupportedException(this.name);
        }

        public boolean isOutputAvailable() {
            return false;
        }

        public ArchiveOutputStream<?> createArchiveOutputStream(OutputStream out, Charset charset) throws ArchiveException {
            throw new StreamingNotSupportedException(this.name);
        }

        public String toString() {
            return this.name + " archiver";
        }
    }
}

