/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.Consumer;

@FunctionalInterface
public interface IOConsumer<T> {
    public static final IOConsumer<?> NOOP_IO_CONSUMER = t -> {};

    public static <T> IOConsumer<T> noop() {
        return NOOP_IO_CONSUMER;
    }

    public void accept(T var1) throws IOException;

    default public IOConsumer<T> andThen(IOConsumer<? super T> after) {
        Objects.requireNonNull(after, "after");
        return t -> {
            this.accept(t);
            after.accept(t);
        };
    }

    default public Consumer<T> asConsumer() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }
}

