/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Objects;
import kala.compress.function.IOConsumer;

public interface IOIterator<E> {
    public boolean hasNext() throws IOException;

    public E next() throws IOException;

    default public void forEachRemaining(IOConsumer<? super E> action) throws IOException {
        Objects.requireNonNull(action);
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    default public Iterator<E> asIterator() {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                try {
                    return IOIterator.this.hasNext();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public E next() {
                try {
                    return IOIterator.this.next();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }
}

