/*
 * Decompiled with CFR 0.152.
 */
package io.github.palexdev.virtualizedfx.flow.simple;

import io.github.palexdev.virtualizedfx.ResourceManager;
import io.github.palexdev.virtualizedfx.cell.Cell;
import io.github.palexdev.virtualizedfx.flow.base.OrientationHelper;
import io.github.palexdev.virtualizedfx.flow.base.VirtualFlow;
import io.github.palexdev.virtualizedfx.flow.simple.SimpleVirtualFlowContainer;
import io.github.palexdev.virtualizedfx.utils.AnimationUtils;
import io.github.palexdev.virtualizedfx.utils.NumberUtils;
import io.github.palexdev.virtualizedfx.utils.ScrollUtils;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;

public class SimpleVirtualFlow<T, C extends Cell<T>>
extends Region
implements VirtualFlow<T, C> {
    private final String STYLE_CLASS = "virtual-flow";
    private final String STYLESHEET = ResourceManager.loadResource("SimpleVirtualFlow.css");
    private final ObjectProperty<ObservableList<T>> items = new SimpleObjectProperty((Object)FXCollections.observableArrayList());
    private final ObjectProperty<Function<T, C>> cellFactory = new SimpleObjectProperty();
    private final ScrollBar hBar = new ScrollBar();
    private final DoubleProperty horizontalPosition = new SimpleDoubleProperty();
    private final ScrollBar vBar = new ScrollBar();
    private final DoubleProperty verticalPosition = new SimpleDoubleProperty();
    private final BooleanProperty fitToWidth = new SimpleBooleanProperty(true);
    private final BooleanProperty fitToHeight = new SimpleBooleanProperty(true);
    private OrientationHelper orientationHelper;
    private final ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)Orientation.VERTICAL);
    private final SimpleVirtualFlowContainer<T, C> container = new SimpleVirtualFlowContainer(this);
    private boolean initialized = false;
    private final Features features = new Features();

    protected SimpleVirtualFlow() {
    }

    public SimpleVirtualFlow(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
        this.setItems(items);
        this.setCellFactory(cellFactory);
        this.setOrientation(orientation);
        this.orientationHelper = orientation == Orientation.HORIZONTAL ? new OrientationHelper.HorizontalHelper(this, this.container) : new OrientationHelper.VerticalHelper(this, this.container);
        this.initialize();
    }

    public SimpleVirtualFlow(ObjectProperty<ObservableList<T>> items, Function<T, C> cellFactory, Orientation orientation) {
        this.items.bind(items);
        this.setCellFactory(cellFactory);
        this.setOrientation(orientation);
        this.orientationHelper = orientation == Orientation.HORIZONTAL ? new OrientationHelper.HorizontalHelper(this, this.container) : new OrientationHelper.VerticalHelper(this, this.container);
        this.initialize();
    }

    protected void initialize() {
        this.getStyleClass().add((Object)"virtual-flow");
        this.getChildren().add(this.container);
        this.setupScrollBars();
        this.cellFactory.addListener((observable, oldValue, newValue) -> {
            this.scrollToPixel(0.0);
            this.container.getCellsManager().clear();
            this.container.getLayoutManager().setInitialized(false);
            this.container.getLayoutManager().initialize();
        });
        this.orientation.addListener((observable, oldValue, newValue) -> {
            this.scrollToPixel(0.0);
            this.container.getCellsManager().clear();
            this.container.getLayoutManager().setInitialized(false);
            this.features.orientationChanged = true;
            this.orientationHelper.dispose();
            if (newValue == Orientation.VERTICAL) {
                OrientationHelper.VerticalHelper verticalHelper = new OrientationHelper.VerticalHelper(this, this.container);
                this.orientationHelper = verticalHelper;
                verticalHelper.initialize();
            } else {
                OrientationHelper.HorizontalHelper horizontalHelper = new OrientationHelper.HorizontalHelper(this, this.container);
                this.orientationHelper = horizontalHelper;
                horizontalHelper.initialize();
            }
            this.container.getLayoutManager().initialize();
        });
    }

    private void setupScrollBars() {
        this.hBar.setManaged(false);
        this.vBar.setManaged(false);
        this.hBar.setOrientation(Orientation.HORIZONTAL);
        this.vBar.setOrientation(Orientation.VERTICAL);
        this.hBar.setUnitIncrement(15.0);
        this.vBar.setUnitIncrement(15.0);
        this.hBar.maxProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double max = NumberUtils.clamp(this.container.getEstimatedWidth() - this.getWidth(), 0.0, Double.MAX_VALUE);
            if (this.getHorizontalPosition() > max) {
                this.setHorizontalPosition(max);
            }
            return max;
        }, (Observable[])new Observable[]{this.container.estimatedWidthProperty(), this.widthProperty()}));
        this.vBar.maxProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            double max = NumberUtils.clamp(this.container.getEstimatedHeight() - this.getHeight(), 0.0, Double.MAX_VALUE);
            if (this.getVerticalPosition() > max) {
                this.setVerticalPosition(max);
            }
            return max;
        }, (Observable[])new Observable[]{this.container.estimatedHeightProperty(), this.heightProperty()}));
        this.hBar.visibleAmountProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (!this.hBar.isVisible()) {
                return 0.0;
            }
            double viewportHeight = this.getWidth();
            double contentHeight = this.container.getEstimatedWidth();
            double ratio = viewportHeight / contentHeight;
            return viewportHeight - this.hBar.getWidth() * ratio;
        }, (Observable[])new Observable[]{this.vBar.visibleProperty(), this.widthProperty(), this.container.estimatedWidthProperty(), this.vBar.widthProperty()}));
        this.hBar.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.container.getEstimatedWidth() > this.getWidth(), (Observable[])new Observable[]{this.container.estimatedWidthProperty(), this.widthProperty()}));
        this.vBar.visibleAmountProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
            if (!this.vBar.isVisible()) {
                return 0.0;
            }
            double viewportHeight = this.getHeight();
            double contentHeight = this.container.getEstimatedHeight();
            double ratio = viewportHeight / contentHeight;
            return viewportHeight - this.vBar.getHeight() * ratio;
        }, (Observable[])new Observable[]{this.vBar.visibleProperty(), this.heightProperty(), this.container.estimatedHeightProperty(), this.vBar.heightProperty()}));
        this.vBar.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.container.getEstimatedHeight() > this.getHeight(), (Observable[])new Observable[]{this.container.estimatedHeightProperty(), this.heightProperty()}));
        this.horizontalPosition.bindBidirectional((Property)this.hBar.valueProperty());
        this.verticalPosition.bindBidirectional((Property)this.vBar.valueProperty());
        EventDispatcher original = this.getEventDispatcher();
        this.setEventDispatcher((event, tail) -> {
            if (event instanceof ScrollEvent) {
                if (this.getOrientation() == Orientation.VERTICAL) {
                    tail.prepend(this.vBar.getEventDispatcher());
                } else {
                    tail.prepend(this.hBar.getEventDispatcher());
                }
            }
            return original.dispatchEvent(event, tail);
        });
        this.vBar.addEventFilter(ScrollEvent.SCROLL, event -> {
            if (this.getOrientation() == Orientation.HORIZONTAL) {
                event.consume();
            }
        });
        this.hBar.addEventFilter(ScrollEvent.SCROLL, event -> {
            if (this.getOrientation() == Orientation.VERTICAL) {
                event.consume();
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.hBar, this.vBar});
    }

    public C getCell(int index) {
        try {
            return (C)((Cell)this.getCells().get(index));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public Map<Integer, C> getCells() {
        return Collections.unmodifiableMap(this.container.getCells());
    }

    public void scrollBy(double pixels) {
        this.orientationHelper.scrollBy(pixels);
    }

    public void scrollTo(int index) {
        this.orientationHelper.scrollTo(index);
    }

    public void scrollToFirst() {
        this.orientationHelper.scrollToFirst();
    }

    public void scrollToLast() {
        this.orientationHelper.scrollToLast();
    }

    public void scrollToPixel(double pixel) {
        this.orientationHelper.scrollToPixel(pixel);
    }

    public void setHSpeed(double unit, double block) {
        this.hBar.setUnitIncrement(unit);
        this.hBar.setBlockIncrement(block);
    }

    public void setVSpeed(double unit, double block) {
        this.vBar.setUnitIncrement(unit);
        this.vBar.setBlockIncrement(block);
    }

    protected double computePrefWidth(double height) {
        return 100.0;
    }

    protected double computePrefHeight(double width) {
        return 100.0;
    }

    public String getUserAgentStylesheet() {
        return this.STYLESHEET;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double prefVerticalWidth = this.vBar.prefWidth(-1.0);
        double prefHorizontalHeight = this.hBar.prefHeight(-1.0);
        this.vBar.resizeRelocate(this.getWidth() - prefVerticalWidth, 0.0, prefVerticalWidth, this.getHeight());
        this.hBar.resizeRelocate(0.0, this.getHeight() - prefHorizontalHeight, this.getWidth(), prefHorizontalHeight);
        if (!this.initialized) {
            this.initialized = true;
            if (this.orientationHelper instanceof OrientationHelper.HorizontalHelper) {
                OrientationHelper.HorizontalHelper helper = (OrientationHelper.HorizontalHelper)this.orientationHelper;
                helper.initialize();
            } else {
                OrientationHelper.VerticalHelper helper = (OrientationHelper.VerticalHelper)this.orientationHelper;
                helper.initialize();
            }
            this.container.initialize();
        }
    }

    @Override
    public ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    @Override
    public void setItems(ObservableList<T> items) {
        this.items.set(items);
    }

    @Override
    public Function<T, C> getCellFactory() {
        return (Function)this.cellFactory.get();
    }

    @Override
    public ObjectProperty<Function<T, C>> cellFactoryProperty() {
        return this.cellFactory;
    }

    @Override
    public void setCellFactory(Function<T, C> cellFactory) {
        this.cellFactory.set(cellFactory);
    }

    @Override
    public double getCellWidth() {
        return this.container.getCellWidth();
    }

    @Override
    public double getCellHeight() {
        return this.container.getCellHeight();
    }

    @Override
    public ScrollBar getHBar() {
        return this.hBar;
    }

    @Override
    public ScrollBar getVBar() {
        return this.vBar;
    }

    @Override
    public boolean isFitToWidth() {
        return this.fitToWidth.get();
    }

    @Override
    public BooleanProperty fitToWidthProperty() {
        return this.fitToWidth;
    }

    @Override
    public void setFitToWidth(boolean fitToWidth) {
        this.fitToWidth.set(fitToWidth);
    }

    @Override
    public boolean isFitToHeight() {
        return this.fitToHeight.get();
    }

    @Override
    public BooleanProperty fitToHeightProperty() {
        return this.fitToHeight;
    }

    @Override
    public void setFitToHeight(boolean fitToHeight) {
        this.fitToHeight.set(fitToHeight);
    }

    @Override
    public double getVerticalPosition() {
        return this.verticalPosition.get();
    }

    @Override
    public DoubleProperty verticalPositionProperty() {
        return this.verticalPosition;
    }

    @Override
    public void setVerticalPosition(double vValue) {
        this.verticalPosition.set(vValue);
    }

    @Override
    public double getHorizontalPosition() {
        return this.horizontalPosition.get();
    }

    @Override
    public DoubleProperty horizontalPositionProperty() {
        return this.horizontalPosition;
    }

    @Override
    public void setHorizontalPosition(double hValue) {
        this.horizontalPosition.set(hValue);
    }

    public Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation.set((Object)orientation);
    }

    protected OrientationHelper getOrientationHelper() {
        return this.orientationHelper;
    }

    public Features features() {
        return this.features;
    }

    @Override
    public SimpleVirtualFlow<T, C> getVirtualFlow() {
        return this;
    }

    public class Features {
        private Timeline overScrollAnimation;
        private double overScroll = 0.0;
        private boolean overScrollEnabled = false;
        private boolean orientationChanged = false;

        private Features() {
        }

        public void enableBounceEffect() {
            this.enableBounceEffect(5.0, 40.0);
        }

        public void enableBounceEffect(double strength, double maxOverscroll) {
            this.overScrollEnabled = true;
            this.overScrollAnimation = new Timeline();
            this.overScrollAnimation.setOnFinished(event -> {
                this.overScroll = 0.0;
            });
            SimpleVirtualFlow.this.vBar.addEventHandler(ScrollEvent.ANY, event -> {
                int mul;
                if (SimpleVirtualFlow.this.vBar.getValue() == 0.0) {
                    mul = -1;
                } else if (SimpleVirtualFlow.this.vBar.getValue() == SimpleVirtualFlow.this.vBar.getMax()) {
                    mul = 1;
                } else {
                    this.overScrollAnimation.stop();
                    this.overScroll = 0.0;
                    return;
                }
                double pos = -(SimpleVirtualFlow.this.getVerticalPosition() % SimpleVirtualFlow.this.container.getCellHeight());
                this.overScroll = NumberUtils.clamp(this.overScroll - strength, -maxOverscroll, maxOverscroll);
                KeyFrame kf0 = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)SimpleVirtualFlow.this.container.layoutYProperty(), (Object)(pos + this.overScroll * (double)mul), AnimationUtils.INTERPOLATOR_V2)});
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)SimpleVirtualFlow.this.container.layoutYProperty(), (Object)pos, AnimationUtils.INTERPOLATOR_V2)});
                this.overScrollAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
                this.overScrollAnimation.playFromStart();
            });
            SimpleVirtualFlow.this.hBar.addEventHandler(ScrollEvent.ANY, event -> {
                int mul;
                if (SimpleVirtualFlow.this.hBar.getValue() == 0.0) {
                    mul = -1;
                } else if (SimpleVirtualFlow.this.hBar.getValue() == SimpleVirtualFlow.this.hBar.getMax()) {
                    mul = 1;
                } else {
                    this.overScroll = 0.0;
                    this.overScrollAnimation.stop();
                    return;
                }
                double pos = -(SimpleVirtualFlow.this.getHorizontalPosition() % SimpleVirtualFlow.this.container.getCellWidth());
                this.overScroll = NumberUtils.clamp(this.overScroll - strength, -maxOverscroll, maxOverscroll);
                KeyFrame kf0 = new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)SimpleVirtualFlow.this.container.layoutXProperty(), (Object)(pos + this.overScroll * (double)mul), AnimationUtils.INTERPOLATOR_V2)});
                KeyFrame kf1 = new KeyFrame(Duration.millis((double)350.0), new KeyValue[]{new KeyValue((WritableValue)SimpleVirtualFlow.this.container.layoutXProperty(), (Object)pos, AnimationUtils.INTERPOLATOR_V2)});
                this.overScrollAnimation.getKeyFrames().setAll((Object[])new KeyFrame[]{kf0, kf1});
                this.overScrollAnimation.playFromStart();
            });
        }

        public void enableSmoothScrolling(double speed) {
            this.enableSmoothScrolling(speed, 7.0, 0.05);
        }

        public void enableSmoothScrolling(double speed, double trackpadAdjustment) {
            this.enableSmoothScrolling(speed, trackpadAdjustment, 0.05);
        }

        public void enableSmoothScrolling(double speed, double trackPadAdjustment, double scrollThreshold) {
            double[] frictions = new double[]{0.99, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
            double[] derivatives = new double[frictions.length];
            AtomicReference<Double> atomicSpeed = new AtomicReference<Double>(speed);
            Timeline timeline = new Timeline();
            AtomicReference scrollDirection = new AtomicReference();
            AtomicBoolean isTrackpad = new AtomicBoolean(false);
            ChangeListener orientationChangeListener = (observable, oldValue, newValue) -> {
                timeline.stop();
                SimpleVirtualFlow.this.setVerticalPosition(0.0);
                SimpleVirtualFlow.this.setHorizontalPosition(0.0);
            };
            EventHandler mouseHandler = event -> timeline.stop();
            EventHandler scrollHandler = event -> {
                if (this.overScrollEnabled) {
                    this.overScrollAnimation.stop();
                }
                if (this.orientationChanged) {
                    timeline.stop();
                    this.orientationChanged = false;
                    return;
                }
                if (event.getEventType() == ScrollEvent.SCROLL) {
                    scrollDirection.set(ScrollUtils.determineScrollDirection(SimpleVirtualFlow.this.getOrientation(), event.getDeltaY()));
                    isTrackpad.set(ScrollUtils.isTrackPad(event.getDeltaY()));
                    if (isTrackpad.get()) {
                        atomicSpeed.set(speed / (trackPadAdjustment * 100.0));
                    } else {
                        atomicSpeed.set(speed);
                    }
                    derivatives[0] = derivatives[0] + (double)((ScrollUtils.ScrollDirection)((Object)((Object)scrollDirection.get()))).intDirection() * (Double)atomicSpeed.get();
                    if (timeline.getStatus() == Animation.Status.STOPPED) {
                        timeline.play();
                    }
                    if (!this.overScrollEnabled) {
                        event.consume();
                    }
                }
            };
            if (SimpleVirtualFlow.this.getParent() != null) {
                SimpleVirtualFlow.this.getParent().addEventFilter(MouseEvent.MOUSE_PRESSED, mouseHandler);
            }
            SimpleVirtualFlow.this.parentProperty().addListener((observable, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.removeEventFilter(MouseEvent.MOUSE_PRESSED, mouseHandler);
                }
                if (newValue != null) {
                    newValue.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseHandler);
                }
            });
            SimpleVirtualFlow.this.orientation.addListener(orientationChangeListener);
            SimpleVirtualFlow.this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseHandler);
            SimpleVirtualFlow.this.addEventFilter(ScrollEvent.ANY, scrollHandler);
            timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), event -> {
                int i;
                for (i = 0; i < derivatives.length; ++i) {
                    int n = i;
                    derivatives[n] = derivatives[n] * frictions[i];
                }
                for (i = 1; i < derivatives.length; ++i) {
                    int n = i;
                    derivatives[n] = derivatives[n] + derivatives[i - 1];
                }
                double dy = NumberUtils.formatTo(derivatives[derivatives.length - 1], 2);
                DoubleProperty positionProperty = SimpleVirtualFlow.this.getOrientation() == Orientation.VERTICAL ? SimpleVirtualFlow.this.verticalPosition : SimpleVirtualFlow.this.horizontalPosition;
                double max = SimpleVirtualFlow.this.getOrientation() == Orientation.VERTICAL ? SimpleVirtualFlow.this.vBar.getMax() : SimpleVirtualFlow.this.hBar.getMax();
                positionProperty.set(NumberUtils.clamp(positionProperty.get() + dy, 0.0, max));
                if (!isTrackpad.get() && Math.abs(dy) < scrollThreshold) {
                    timeline.stop();
                }
            }, new KeyValue[0]));
            timeline.setCycleCount(-1);
        }
    }

    @Deprecated
    public static class Builder {
        private Builder() {
        }

        public static <T, C extends Cell<T>> SimpleVirtualFlow<T, C> create(ObjectProperty<? extends ObservableList<T>> items, Function<T, C> cellFactory, Orientation orientation) {
            SimpleVirtualFlow<T, C> virtualFlow = new SimpleVirtualFlow<T, C>();
            ((SimpleVirtualFlow)virtualFlow).items.bind(items);
            virtualFlow.setCellFactory(cellFactory);
            virtualFlow.setOrientation(orientation);
            ((SimpleVirtualFlow)virtualFlow).orientationHelper = orientation == Orientation.HORIZONTAL ? new OrientationHelper.HorizontalHelper(virtualFlow, ((SimpleVirtualFlow)virtualFlow).container) : new OrientationHelper.VerticalHelper(virtualFlow, ((SimpleVirtualFlow)virtualFlow).container);
            virtualFlow.initialize();
            return virtualFlow;
        }

        public static <T, C extends Cell<T>> SimpleVirtualFlow<T, C> create(ObservableList<T> items, Function<T, C> cellFactory, Orientation orientation) {
            SimpleVirtualFlow<T, C> virtualFlow = new SimpleVirtualFlow<T, C>();
            virtualFlow.setItems(items);
            virtualFlow.setCellFactory(cellFactory);
            virtualFlow.setOrientation(orientation);
            ((SimpleVirtualFlow)virtualFlow).orientationHelper = orientation == Orientation.HORIZONTAL ? new OrientationHelper.HorizontalHelper(virtualFlow, ((SimpleVirtualFlow)virtualFlow).container) : new OrientationHelper.VerticalHelper(virtualFlow, ((SimpleVirtualFlow)virtualFlow).container);
            virtualFlow.initialize();
            return virtualFlow;
        }
    }
}

