/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.mic;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.glavo.mic.tasks.CompileModuleInfo;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;

public class CompileModuleInfoPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        SourceSet main;
        project.getPlugins().apply("java");
        try {
            if (GradleVersion.current().compareTo(GradleVersion.version((String)"7.1")) >= 0) {
                JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
                main = (SourceSet)javaPluginExtension.getSourceSets().getByName("main");
            } else {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                main = (SourceSet)javaConvention.getSourceSets().getByName("main");
            }
        }
        catch (IllegalStateException | UnknownDomainObjectException e) {
            throw new GradleException("Cannot obtain JavaPluginConvention", e);
        }
        Optional<Path> moduleInfoJava = main.getAllJava().getSourceDirectories().getFiles().stream().map(sourceDir -> sourceDir.toPath().resolve("module-info.java")).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findAny();
        if (moduleInfoJava.isPresent()) {
            JavaCompile compileJava = (JavaCompile)project.getTasks().getByName("compileJava");
            compileJava.getModularity().getInferModulePath().set((Object)false);
            compileJava.exclude(new String[]{"module-info.java"});
            final Path path = moduleInfoJava.get();
            final Path outputDir = project.getBuildDir().toPath().resolve("classes").resolve("module-info").resolve("main");
            main.getOutput().dir((Object)outputDir);
            TaskProvider compileModuleInfo = project.getTasks().register("compileModuleInfo", CompileModuleInfo.class, (Action)new Action<CompileModuleInfo>(){

                public void execute(CompileModuleInfo task) {
                    task.getSourceFile().set(path.toFile());
                    task.getTargetFile().set(outputDir.resolve("module-info.class").toFile());
                }
            });
            project.getTasks().getByName("classes").dependsOn(new Object[]{compileModuleInfo});
        }
    }
}

