/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.mic;

import com.github.javaparser.ParseProblemException;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Name;
import com.github.javaparser.ast.modules.ModuleDeclaration;
import com.github.javaparser.ast.modules.ModuleDirective;
import com.github.javaparser.ast.modules.ModuleExportsDirective;
import com.github.javaparser.ast.modules.ModuleOpensDirective;
import com.github.javaparser.ast.modules.ModuleProvidesDirective;
import com.github.javaparser.ast.modules.ModuleRequiresDirective;
import com.github.javaparser.ast.modules.ModuleUsesDirective;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.ModuleVisitor;

public class ModuleInfoCompiler {
    public static final int DEFAULT_TARGET_COMPATIBILITY = 9;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final int targetCompatibility;
    private final String moduleVersion;
    private final String mainClass;

    public ModuleInfoCompiler() {
        this.targetCompatibility = 9;
        this.moduleVersion = null;
        this.mainClass = null;
    }

    public ModuleInfoCompiler(int targetCompatibility, String moduleVersion, String mainClass) {
        if (targetCompatibility < 9) {
            throw new IllegalArgumentException();
        }
        this.targetCompatibility = targetCompatibility;
        this.moduleVersion = moduleVersion;
        this.mainClass = mainClass;
    }

    private static String[] moduleNameListToArray(NodeList<Name> list) {
        if (list.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] res = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = ((Name)list.get(i)).asString();
        }
        return res;
    }

    private static String[] packageNameListToArray(NodeList<Name> list) {
        if (list.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        String[] res = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            res[i] = ((Name)list.get(i)).asString().replace('.', '/');
        }
        return res;
    }

    public void compile(Path source, Path target) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(source);
             OutputStream output = Files.newOutputStream(target, new OpenOption[0]);){
            this.compile(reader, output);
        }
    }

    public void compile(Reader source, OutputStream target) throws IOException {
        try {
            CompilationUnit compilationUnit = StaticJavaParser.parse((Reader)source);
            ModuleDeclaration md = (ModuleDeclaration)compilationUnit.getModule().orElseThrow(() -> new IOException("Module not found in source code"));
            ClassWriter classWriter = new ClassWriter(0);
            classWriter.visit(44 + this.targetCompatibility, 32768, "module-info", null, null, null);
            ModuleVisitor moduleVisitor = classWriter.visitModule(md.getNameAsString(), md.isOpen() ? 32 : 0, this.moduleVersion);
            if (this.mainClass != null) {
                moduleVisitor.visitMainClass(this.mainClass.replace('.', '/'));
            }
            if (!md.getNameAsString().equals("java.base")) {
                moduleVisitor.visitRequire("java.base", 0, null);
            }
            for (ModuleDirective directive : md.getDirectives()) {
                if (directive.isModuleExportsDirective()) {
                    ModuleExportsDirective export = directive.asModuleExportsDirective();
                    moduleVisitor.visitExport(export.getNameAsString().replace('.', '/'), 0, ModuleInfoCompiler.moduleNameListToArray((NodeList<Name>)export.getModuleNames()));
                    continue;
                }
                if (directive.isModuleOpensDirective()) {
                    ModuleOpensDirective open = directive.asModuleOpensDirective();
                    moduleVisitor.visitOpen(open.getNameAsString().replace('.', '/'), 0, ModuleInfoCompiler.moduleNameListToArray((NodeList<Name>)open.getModuleNames()));
                    continue;
                }
                if (directive.isModuleProvidesDirective()) {
                    ModuleProvidesDirective provides = directive.asModuleProvidesDirective();
                    moduleVisitor.visitProvide(provides.getNameAsString().replace('.', '/'), ModuleInfoCompiler.packageNameListToArray((NodeList<Name>)provides.getWith()));
                    continue;
                }
                if (directive.isModuleRequiresDirective()) {
                    ModuleRequiresDirective requires = directive.asModuleRequiresDirective();
                    if (requires.getNameAsString().equals("java.base")) continue;
                    int access = 0;
                    for (Modifier modifier : requires.getModifiers()) {
                        if (modifier.getKeyword() == Modifier.Keyword.STATIC) {
                            access |= 0x40;
                            continue;
                        }
                        if (modifier.getKeyword() != Modifier.Keyword.TRANSITIVE) continue;
                        access |= 0x20;
                    }
                    moduleVisitor.visitRequire(requires.getNameAsString(), access, null);
                    continue;
                }
                if (directive.isModuleUsesDirective()) {
                    ModuleUsesDirective uses = directive.asModuleUsesDirective();
                    moduleVisitor.visitUse(uses.getNameAsString().replace('.', '/'));
                    continue;
                }
                throw new AssertionError((Object)("Unknown module directive: " + directive));
            }
            target.write(classWriter.toByteArray());
        }
        catch (ParseProblemException e) {
            throw new IOException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        int i;
        String HELP_MESSAGE = "Usage: gmic [-target <target compatibility>] [-main-class <module main class>] [-module-version <module version>] <source file> <target file>";
        int targetCompatibility = 9;
        String moduleVersion = null;
        String mainClass = null;
        block17: for (i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-?": 
                case "-help": 
                case "--help": {
                    System.out.println(HELP_MESSAGE);
                    return;
                }
                case "-target": 
                case "--target": {
                    if (i == args.length - 1) {
                        System.err.println(arg + "  requires an argument");
                        System.exit(1);
                        return;
                    }
                    if ((targetCompatibility = Integer.parseInt(args[++i])) >= 9) continue block17;
                    System.err.println("The target version needs to be greater than or equal to 9");
                    System.exit(1);
                    return;
                }
                case "-module-version": 
                case "--module-version": {
                    if (i == args.length - 1) {
                        System.err.println(arg + "  requires an argument");
                        System.exit(1);
                        return;
                    }
                    moduleVersion = args[++i];
                    continue block17;
                }
                case "-main-class": 
                case "--main-class": {
                    if (i == args.length - 1) {
                        System.err.println(arg + "  requires an argument");
                        System.exit(1);
                        return;
                    }
                    mainClass = args[++i];
                    continue block17;
                }
            }
        }
        if (args.length - i != 2) {
            System.err.println(HELP_MESSAGE);
            System.exit(1);
            return;
        }
        Path sourceFile = Paths.get(args[i], new String[0]);
        Path targetFile = Paths.get(args[i + 1], new String[0]);
        ModuleInfoCompiler compiler = new ModuleInfoCompiler(targetCompatibility, moduleVersion, mainClass);
        compiler.compile(sourceFile, targetFile);
    }
}

