/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.mic.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.glavo.mic.ModuleInfoCompiler;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public abstract class CompileModuleInfo
extends DefaultTask {
    private int targetCompatibility = 9;
    private String moduleVersion;
    private String moduleMainClass;
    private String encoding = "UTF-8";

    @InputFile
    public abstract RegularFileProperty getSourceFile();

    @OutputFile
    public abstract RegularFileProperty getTargetFile();

    @Input
    public int getTargetCompatibility() {
        return this.targetCompatibility;
    }

    public void setTargetCompatibility(int targetCompatibility) {
        this.targetCompatibility = targetCompatibility;
    }

    @Input
    @Optional
    public String getModuleVersion() {
        return this.moduleVersion;
    }

    public void setModuleVersion(String moduleVersion) {
        this.moduleVersion = moduleVersion;
    }

    @Input
    @Optional
    public String getModuleMainClass() {
        return this.moduleMainClass;
    }

    public void setModuleMainClass(String moduleMainClass) {
        this.moduleMainClass = moduleMainClass;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @TaskAction
    public void compile() throws IOException {
        File source = (File)this.getSourceFile().getAsFile().get();
        File target = (File)this.getTargetFile().getAsFile().get();
        target.getParentFile().mkdirs();
        ModuleInfoCompiler compiler = new ModuleInfoCompiler(this.targetCompatibility, this.moduleVersion, this.moduleMainClass);
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(source.toPath(), new OpenOption[0]), this.encoding);
             OutputStream output = Files.newOutputStream(target.toPath(), new OpenOption[0]);){
            compiler.compile(reader, output);
        }
    }
}

