/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glowroot.agent.AgentDirsLocking;
import org.glowroot.agent.NotGuava;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.util.OnlyUsedByTests;

public class Directories {
    private static final String RESERVED_CHARACTERS = "<>:\"/\\|?*";
    @Nullable
    private final File glowrootJarFile;
    private final File glowrootDir;
    @Nullable
    private final File pluginsDir;
    private final List<File> confDirs;
    @Nullable
    private final Closeable agentDirLockCloseable;
    private final File logDir;
    private final File tmpDir;
    private final Properties rootProperties;
    private final boolean multiDir;
    @Nullable
    private final String agentId;
    private final Helper helper;

    public Directories(@Nullable File glowrootJarFile) throws Exception {
        Pattern pattern;
        Matcher matcher;
        this.glowrootJarFile = glowrootJarFile;
        this.glowrootDir = Directories.getGlowrootDir(glowrootJarFile);
        File pluginsDir = new File(this.glowrootDir, "plugins");
        this.pluginsDir = pluginsDir.exists() ? pluginsDir : null;
        this.confDirs = new ArrayList<File>();
        this.confDirs.add(this.glowrootDir);
        this.rootProperties = new Properties();
        File propFile = new File(this.glowrootDir, "glowroot.properties");
        if (propFile.exists()) {
            Directories.loadInto(propFile, this.rootProperties);
        }
        File explicitConfDir = Directories.getExplicitDir("conf", this.rootProperties);
        File explicitLogDir = Directories.getExplicitDir("log", this.rootProperties);
        File explicitTmpDir = Directories.getExplicitDir("tmp", this.rootProperties);
        if (explicitConfDir != null) {
            this.confDirs.add(explicitConfDir);
        }
        this.multiDir = Boolean.getBoolean("glowroot.multi.dir") || Boolean.parseBoolean(this.rootProperties.getProperty("multi.dir"));
        String agentIdTemplate = Directories.getProperty("agent.id", this.rootProperties);
        String agentIdBeforeNumber = null;
        Integer agentNumber = null;
        Helper helper = null;
        File tmpDir = null;
        Closeable agentDirLockCloseable = null;
        if (agentIdTemplate != null && (matcher = (pattern = Pattern.compile("\\{\\{(\\d+)\\.\\.(\\d+)}}$")).matcher(agentIdTemplate)).find()) {
            int from = Integer.parseInt(NotGuava.checkNotNull(matcher.group(1)));
            int to = Integer.parseInt(NotGuava.checkNotNull(matcher.group(2)));
            agentIdBeforeNumber = agentIdTemplate.substring(0, matcher.start());
            agentNumber = from;
            while (agentNumber <= to && (agentDirLockCloseable = AgentDirsLocking.tryLockAgentDirs(tmpDir = NotGuava.mkdirs((helper = new Helper(this.glowrootDir, this.multiDir, agentIdBeforeNumber, agentNumber)).getDir(explicitTmpDir, "tmp")), false)) == null) {
                Integer n = agentNumber;
                Integer n2 = agentNumber = Integer.valueOf(agentNumber + 1);
            }
        }
        if (agentNumber == null) {
            this.agentId = agentIdTemplate;
            agentIdBeforeNumber = agentIdTemplate;
            helper = new Helper(this.glowrootDir, this.multiDir, this.agentId, null);
            tmpDir = NotGuava.mkdirs(helper.getDir(explicitTmpDir, "tmp"));
            agentDirLockCloseable = AgentDirsLocking.tryLockAgentDirs(tmpDir, true);
        } else {
            this.agentId = agentIdBeforeNumber + agentNumber;
            NotGuava.checkNotNull(helper);
            NotGuava.checkNotNull(tmpDir);
        }
        if (this.multiDir && this.agentId != null || agentNumber != null) {
            File confDir = explicitConfDir == null ? helper.getDefaultBaseDir() : NotGuava.mkdirs(Directories.safelyNamedDir(explicitConfDir, NotGuava.checkNotNull(this.agentId)));
            if (this.multiDir && agentNumber != null) {
                this.confDirs.add(NotGuava.checkNotNull(confDir.getParentFile()));
            }
            this.confDirs.add(confDir);
        }
        this.helper = helper;
        this.tmpDir = tmpDir;
        this.agentDirLockCloseable = agentDirLockCloseable;
        this.logDir = NotGuava.mkdirs(helper.getDir(explicitLogDir, "logs"));
        Collections.reverse(this.confDirs);
    }

    @OnlyUsedByTests
    Directories(File testDir, boolean dummy) throws Exception {
        this.glowrootJarFile = null;
        this.glowrootDir = testDir;
        this.pluginsDir = null;
        this.confDirs = Arrays.asList(testDir);
        this.rootProperties = new Properties();
        this.multiDir = false;
        this.agentId = null;
        this.helper = new Helper(testDir, false, null, null);
        this.logDir = testDir;
        this.tmpDir = NotGuava.mkdirs(this.helper.getDir(null, "tmp"));
        this.agentDirLockCloseable = AgentDirsLocking.tryLockAgentDirs(this.tmpDir, true);
    }

    boolean logStartupErrorMultiDirWithMissingAgentId() {
        return this.multiDir && this.agentId == null;
    }

    @Nullable
    public File getGlowrootJarFile() {
        return this.glowrootJarFile;
    }

    File getGlowrootDir() {
        return this.glowrootDir;
    }

    @Nullable
    File getPluginsDir() {
        return this.pluginsDir;
    }

    public List<File> getConfDirs() {
        return this.confDirs;
    }

    public File getConfDir() {
        return this.confDirs.get(0);
    }

    public File getLogDir() {
        return this.logDir;
    }

    public File getTmpDir() {
        return this.tmpDir;
    }

    @Nullable
    public Closeable getAgentDirLockCloseable() {
        return this.agentDirLockCloseable;
    }

    @Nullable
    File getEmbeddedCollectorJarFile() {
        return Directories.getEmbeddedCollectorJarFile(this.glowrootJarFile);
    }

    @Nullable
    File getCentralCollectorHttpsJarFile(String normalizedOsName) {
        if (this.glowrootJarFile == null) {
            return null;
        }
        File libDir = new File(this.glowrootJarFile.getParentFile(), "lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            return null;
        }
        File jarFile = new File(libDir, "glowroot-central-collector-https-" + normalizedOsName + ".jar");
        return jarFile.exists() ? jarFile : null;
    }

    @Nullable
    File getLoggingLogstashJarFile() {
        if (this.glowrootJarFile == null) {
            return null;
        }
        File libDir = new File(this.glowrootJarFile.getParentFile(), "lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            return null;
        }
        File jarFile = new File(libDir, "glowroot-logging-logstash.jar");
        return jarFile.exists() ? jarFile : null;
    }

    public File getDataDir() throws IOException {
        File explicitDataDir = Directories.getExplicitDir("data", this.rootProperties);
        return NotGuava.mkdirs(this.helper.getDir(explicitDataDir, "data"));
    }

    public boolean hasDataDir() throws IOException {
        File explicitDataDir = Directories.getExplicitDir("data", this.rootProperties);
        File dataDir = this.helper.getDir(explicitDataDir, "data");
        return dataDir.exists();
    }

    @Nullable
    static File getEmbeddedCollectorJarFile(@Nullable File glowrootJarFile) {
        if (glowrootJarFile == null) {
            return null;
        }
        File libDir = new File(glowrootJarFile.getParentFile(), "lib");
        if (!libDir.exists() || !libDir.isDirectory()) {
            return null;
        }
        File jarFile = new File(libDir, "glowroot-embedded-collector.jar");
        return jarFile.exists() ? jarFile : null;
    }

    private static File getGlowrootDir(@Nullable File glowrootJarFile) {
        String testDirPath = System.getProperty("glowroot.test.dir");
        if (testDirPath != null && !testDirPath.isEmpty()) {
            return new File(testDirPath);
        }
        if (glowrootJarFile == null) {
            throw new IllegalStateException("Property glowroot.test.dir is required when running tests with no glowroot jar file");
        }
        File glowrootDir = glowrootJarFile.getParentFile();
        if (glowrootDir == null) {
            return new File(".");
        }
        return glowrootDir;
    }

    @Nullable
    private static File getExplicitDir(String shortName, Properties rootProperties) {
        String explicitDirPath = Directories.getProperty(shortName + ".dir", rootProperties);
        if (explicitDirPath == null) {
            return null;
        }
        return new File(explicitDirPath);
    }

    @Nullable
    private static String getProperty(String name, Properties rootProperties) {
        String value = Directories.normalizePropertyValue(System.getProperty("glowroot." + name));
        if (value != null) {
            return value;
        }
        value = Directories.normalizePropertyValue(rootProperties.getProperty(name));
        if (value != null) {
            return value;
        }
        return null;
    }

    @Nullable
    private static String normalizePropertyValue(@Nullable String propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        String trimmed = propertyValue.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static File safelyNamedDir(File parentDir, String name) throws IOException {
        String oldFormatSafeName;
        File oldFormatDir;
        String safeName = Directories.makeSafeDirName(name, true);
        File dir = new File(parentDir, safeName);
        if (!dir.exists() && !safeName.equals(name) && (oldFormatDir = new File(parentDir, oldFormatSafeName = Directories.makeSafeDirName(name, false))).exists() && !oldFormatDir.renameTo(dir)) {
            throw new IOException("Unable to rename directory '" + oldFormatDir.getAbsolutePath() + "' to '" + dir.getAbsolutePath() + "' as part of upgrade to 0.11.0 or later");
        }
        return dir;
    }

    static String makeSafeDirName(String name, boolean newFormat) {
        StringBuilder safeName = new StringBuilder(name.length());
        int numTrailingDots = 0;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (RESERVED_CHARACTERS.indexOf(c) == -1) {
                safeName.append(c);
            } else if (newFormat) {
                safeName.append('-');
            }
            if (c == '.') {
                ++numTrailingDots;
                continue;
            }
            numTrailingDots = 0;
        }
        if (numTrailingDots > 0) {
            safeName.setLength(safeName.length() - numTrailingDots);
        }
        return safeName.toString();
    }

    private static void loadInto(File propFile, Properties props) throws IOException {
        FileInputStream in = new FileInputStream(propFile);
        try {
            props.load(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static class Helper {
        private final File glowrootDir;
        private final boolean multiDir;
        @Nullable
        private final String agentIdBeforeNumber;
        @Nullable
        private final Integer agentNumber;
        @MonotonicNonNull
        private File defaultBaseDir;

        private Helper(File glowrootDir, boolean multiDir, @Nullable String agentIdBeforeNumber, @Nullable Integer agentNumber) {
            this.glowrootDir = glowrootDir;
            this.multiDir = multiDir;
            this.agentIdBeforeNumber = agentIdBeforeNumber;
            this.agentNumber = agentNumber;
        }

        private File getDir(@Nullable File explicitDir, String name) throws IOException {
            if (explicitDir == null) {
                return new File(this.getDefaultBaseDir(), name);
            }
            if (this.multiDir && this.agentIdBeforeNumber != null) {
                File dir = Directories.safelyNamedDir(explicitDir, this.agentIdBeforeNumber);
                if (this.agentNumber == null) {
                    return dir;
                }
                return new File(dir, Integer.toString(this.agentNumber));
            }
            return explicitDir;
        }

        private File getDefaultBaseDir() throws IOException {
            if (this.defaultBaseDir == null) {
                this.defaultBaseDir = this.createDefaultBaseDir();
            }
            return this.defaultBaseDir;
        }

        private File createDefaultBaseDir() throws IOException {
            if (this.multiDir && this.agentIdBeforeNumber != null) {
                File dir = this.getGlowrootSubDir(this.agentIdBeforeNumber);
                if (this.agentNumber == null) {
                    return dir;
                }
                return NotGuava.mkdirs(new File(dir, Integer.toString(this.agentNumber)));
            }
            if (this.agentNumber == null) {
                return this.glowrootDir;
            }
            return NotGuava.mkdirs(this.getGlowrootSubDir(this.agentIdBeforeNumber + this.agentNumber));
        }

        private File getGlowrootSubDir(String name) throws IOException {
            return Directories.safelyNamedDir(this.glowrootDir, "agent-" + name);
        }
    }
}

