/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.config;

import java.util.List;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@Value.Immutable
public abstract class PropertyDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDescriptor.class);

    public abstract String name();

    public abstract PropertyValue.PropertyType type();

    @JsonProperty(value="default")
    @Nullable
    public abstract PropertyValue defaultValue();

    public abstract String label();

    @Value.Default
    public String checkboxLabel() {
        return "";
    }

    @Value.Default
    public String description() {
        return "";
    }

    @JsonIgnore
    PropertyValue getValidatedNonNullDefaultValue() {
        PropertyValue defaultValue = this.defaultValue();
        if (defaultValue == null) {
            return PropertyDescriptor.getDefaultValue(this.type());
        }
        Object value = defaultValue.value();
        if (value == null) {
            return PropertyDescriptor.getDefaultValue(this.type());
        }
        if (PropertyDescriptor.isValidType(value, this.type())) {
            return new PropertyValue(value);
        }
        logger.warn("invalid default value for plugin property: {}", (Object)this.name());
        return PropertyDescriptor.getDefaultValue(this.type());
    }

    static PropertyValue getDefaultValue(PropertyValue.PropertyType type) {
        switch (type) {
            case BOOLEAN: {
                return new PropertyValue(false);
            }
            case DOUBLE: {
                return new PropertyValue(null);
            }
            case STRING: {
                return new PropertyValue("");
            }
            case LIST: {
                return new PropertyValue(ImmutableList.of());
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)type)));
    }

    static boolean isValidType(Object value, PropertyValue.PropertyType type) {
        switch (type) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case STRING: {
                return value instanceof String;
            }
            case DOUBLE: {
                return value instanceof Double;
            }
            case LIST: {
                return value instanceof List;
            }
        }
        throw new AssertionError((Object)("Unexpected property type: " + (Object)((Object)type)));
    }
}

