/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.agent.bytecode.api.BytecodeService;
import org.glowroot.agent.bytecode.api.MessageTemplate;
import org.glowroot.agent.bytecode.api.ThreadContextPlus;
import org.glowroot.agent.bytecode.api.ThreadContextThreadLocal;
import org.glowroot.agent.impl.OptionalThreadContextImpl;
import org.glowroot.agent.impl.PreloadSomeSuperTypesCache;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.impl.TransactionService;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.MethodInfo;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.BootstrapMetaHolders;
import org.glowroot.agent.weaving.GenericMessageSupplier;
import org.glowroot.agent.weaving.MessageTemplateImpl;

public class BytecodeServiceImpl
implements BytecodeService {
    private static final boolean DEBUG_MAIN_CLASS = Boolean.getBoolean("glowroot.debug.mainClass");
    private static final Logger logger = LoggerFactory.getLogger(BytecodeServiceImpl.class);
    private final TransactionRegistry transactionRegistry;
    private final TransactionService transactionService;
    @MonotonicNonNull
    private volatile OnEnteringMain onEnteringMain;
    private final AtomicBoolean hasRunOnEnteringMain = new AtomicBoolean();
    @MonotonicNonNull
    private volatile Runnable onExitingGetPlatformMBeanServer;
    private final AtomicBoolean hasRunOnExitingGetPlatformMBeanServer = new AtomicBoolean();
    private final PreloadSomeSuperTypesCache preloadSomeSuperTypesCache;
    private final ThreadLocal<Set<String>> currentlyLoadingTypesHolder = new ThreadLocal();

    public BytecodeServiceImpl(TransactionRegistry transactionRegistry, TransactionService transactionService, PreloadSomeSuperTypesCache preloadSomeSuperTypesCache) {
        this.transactionRegistry = transactionRegistry;
        this.transactionService = transactionService;
        this.preloadSomeSuperTypesCache = preloadSomeSuperTypesCache;
    }

    public void setOnEnteringMain(OnEnteringMain onEnteringMain) {
        this.onEnteringMain = onEnteringMain;
    }

    public void setOnExitingGetPlatformMBeanServer(Runnable onExitingGetPlatformMBeanServer) {
        this.onExitingGetPlatformMBeanServer = onExitingGetPlatformMBeanServer;
    }

    @Override
    public void enteringMainMethod(String mainClass, @Nullable String[] mainArgs) {
        this.enteringMainMethod(mainClass, mainArgs, mainClass, "main");
    }

    @Override
    public void enteringApacheCommonsDaemonLoadMethod(String mainClass, @Nullable String[] mainArgs) {
        this.enteringMainMethod(mainClass, mainArgs, "org.apache.commons.daemon.support.DaemonLoader", "load");
    }

    @Override
    public void enteringPossibleProcrunStartMethod(String className, String methodName, @Nullable String[] methodArgs) {
        this.enteringMainMethod(className, methodArgs, className, methodName);
    }

    @Override
    public void exitingGetPlatformMBeanServer() {
        if (this.onExitingGetPlatformMBeanServer == null) {
            return;
        }
        if (this.hasRunOnExitingGetPlatformMBeanServer.getAndSet(true)) {
            return;
        }
        try {
            this.onExitingGetPlatformMBeanServer.run();
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    @Override
    public ThreadContextThreadLocal.Holder getCurrentThreadContextHolder() {
        return this.transactionRegistry.getCurrentThreadContextHolder();
    }

    @Override
    public ThreadContextPlus createOptionalThreadContext(ThreadContextThreadLocal.Holder threadContextHolder, int currentNestingGroupId, int currentSuppressionKeyId) {
        return OptionalThreadContextImpl.create(this.transactionService, threadContextHolder, currentNestingGroupId, currentSuppressionKeyId);
    }

    @Override
    public Object getClassMeta(int index) throws Exception {
        return BootstrapMetaHolders.getClassMeta(index);
    }

    @Override
    public Object getMethodMeta(int index) throws Exception {
        return BootstrapMetaHolders.getMethodMeta(index);
    }

    @Override
    public MessageTemplate createMessageTemplate(String template, MethodInfo methodInfo) {
        return MessageTemplateImpl.create(template, methodInfo);
    }

    @Override
    public MessageSupplier createMessageSupplier(MessageTemplate template, Object receiver, String methodName, Object ... args) {
        return GenericMessageSupplier.create((MessageTemplateImpl)template, receiver, methodName, args);
    }

    @Override
    public String getMessageText(MessageTemplate template, Object receiver, String methodName, Object ... args) {
        return GenericMessageSupplier.create((MessageTemplateImpl)template, receiver, methodName, args).getMessageText();
    }

    @Override
    public void updateWithReturnValue(TraceEntry traceEntry, @Nullable Object returnValue) {
        GenericMessageSupplier.updateWithReturnValue(traceEntry, returnValue);
    }

    @Override
    public void logThrowable(Throwable throwable) {
        logger.error(throwable.getMessage(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preloadSomeSuperTypes(ClassLoader loader, @Nullable String className) {
        boolean topLevel;
        if (className == null) {
            return;
        }
        Set<String> preloadSomeSuperTypes = this.preloadSomeSuperTypesCache.get(className);
        if (preloadSomeSuperTypes.isEmpty()) {
            return;
        }
        Set<String> currentlyLoadingTypes = this.currentlyLoadingTypesHolder.get();
        if (currentlyLoadingTypes == null) {
            currentlyLoadingTypes = Sets.newLinkedHashSet();
            this.currentlyLoadingTypesHolder.set(currentlyLoadingTypes);
            topLevel = true;
        } else {
            if (currentlyLoadingTypes.iterator().next().equals(className)) {
                throw new AbortPreload();
            }
            topLevel = false;
        }
        if (!currentlyLoadingTypes.add(className)) {
            return;
        }
        try {
            for (String superClassName : preloadSomeSuperTypes) {
                logger.debug("pre-loading super class {} for {}, in loader={}@{}", superClassName, className, loader.getClass().getName(), loader.hashCode());
                try {
                    Class.forName(superClassName, false, loader);
                }
                catch (ClassNotFoundException e) {
                    logger.debug("super class {} not found (for sub-class {})", superClassName, className, e);
                }
                catch (LinkageError e) {
                    logger.debug("linkage error occurred while loading super class {} (for sub-class {})", superClassName, className, e);
                }
                catch (AbortPreload abortPreload) {}
            }
        }
        finally {
            if (topLevel) {
                this.currentlyLoadingTypesHolder.remove();
            } else {
                currentlyLoadingTypes.remove(className);
            }
        }
    }

    public void enteringMainMethod(String className, @Nullable String[] methodArgs, String expectedTopLevelClassName, String expectedTopLevelMethodName) {
        if (this.onEnteringMain == null) {
            if (DEBUG_MAIN_CLASS) {
                logger.info("entering {}.main(), but callback not set yet", (Object)className, (Object)new Exception("location stack trace"));
            }
            return;
        }
        if (this.hasRunOnEnteringMain.get()) {
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (BytecodeServiceImpl.ignoreMainClass(expectedTopLevelClassName, expectedTopLevelMethodName, stackTrace)) {
            if (DEBUG_MAIN_CLASS) {
                logger.info("ignoring {}.main()", (Object)className, (Object)new Exception("location stack trace"));
            }
            return;
        }
        if (className.equals("com.ibm.java.diagnostics.healthcenter.agent.mbean.HCLaunchMBean")) {
            return;
        }
        if (this.hasRunOnEnteringMain.getAndSet(true)) {
            return;
        }
        String unwrappedMainClass = className.startsWith("org.tanukisoftware.wrapper.") && methodArgs != null && methodArgs.length > 0 ? methodArgs[0] : className;
        if (DEBUG_MAIN_CLASS) {
            logger.info("entering {}.main()", (Object)className, (Object)new Exception("location stack trace"));
        }
        try {
            this.onEnteringMain.run(unwrappedMainClass);
        }
        catch (Throwable t) {
            logger.error(t.getMessage(), t);
        }
    }

    private static boolean ignoreMainClass(String expectedTopLevelClass, String expectedTopLevelMethodName, StackTraceElement[] stackTrace) {
        if (stackTrace.length == 0) {
            return true;
        }
        StackTraceElement topStackTraceElement = stackTrace[stackTrace.length - 1];
        return !topStackTraceElement.getClassName().equals(expectedTopLevelClass) || !expectedTopLevelMethodName.equals(topStackTraceElement.getMethodName());
    }

    private static class AbortPreload
    extends RuntimeException {
        private AbortPreload() {
        }
    }

    public static interface OnEnteringMain {
        public void run(@Nullable String var1) throws Exception;
    }
}

