/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.primitives.Ints;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

public class GlowrootServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(GlowrootServiceImpl.class);
    private final TransactionRegistry transactionRegistry;

    public GlowrootServiceImpl(TransactionRegistry transactionRegistry) {
        this.transactionRegistry = transactionRegistry;
    }

    public void setTransactionType(@Nullable String transactionType) {
        if (Strings.isNullOrEmpty(transactionType)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionType(transactionType, 1000);
        }
    }

    public void setTransactionName(@Nullable String transactionName) {
        if (Strings.isNullOrEmpty(transactionName)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setTransactionName(transactionName, 1000);
        }
    }

    public void setTransactionUser(@Nullable String user) {
        if (Strings.isNullOrEmpty(user)) {
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setUser(user, 1000);
        }
    }

    public void addTransactionAttribute(String name, @Nullable String value) {
        if (name == null) {
            logger.error("addTransactionAttribute(): argument 'name' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.addAttribute(name, value);
        }
    }

    public void setTransactionSlowThreshold(long threshold, TimeUnit unit) {
        if (threshold < 0L) {
            logger.error("setTransactionSlowThreshold(): argument 'threshold' must be non-negative");
            return;
        }
        if (unit == null) {
            logger.error("setTransactionSlowThreshold(): argument 'unit' must be non-null");
            return;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            int thresholdMillis = Ints.saturatedCast(unit.toMillis(threshold));
            transaction.setSlowThresholdMillis(thresholdMillis, 1000);
        }
    }

    public void setTransactionOuter() {
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction != null) {
            transaction.setOuter();
        }
    }
}

