/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TimerImpl;
import org.glowroot.agent.impl.TraceEntryImpl;
import org.glowroot.agent.model.AsyncTimer;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class TraceEntryComponent {
    private static final Logger logger = LoggerFactory.getLogger(TraceEntryComponent.class);
    private final long startTick;
    private boolean completed;
    private long endTick;
    private final ThreadContextImpl threadContext;
    private final TraceEntryImpl rootEntry;
    private TraceEntryImpl activeEntry;
    private TraceEntryImpl tailEntry;

    TraceEntryComponent(ThreadContextImpl threadContext, MessageSupplier messageSupplier, TimerImpl timer, long startTick) {
        this.threadContext = threadContext;
        this.startTick = startTick;
        this.activeEntry = this.rootEntry = new TraceEntryImpl(threadContext, null, messageSupplier, null, 0L, startTick, timer, null);
        this.tailEntry = this.rootEntry;
    }

    TraceEntryImpl getRootEntry() {
        return this.rootEntry;
    }

    long getStartTick() {
        return this.startTick;
    }

    boolean isCompleted() {
        return this.completed;
    }

    long getEndTick() {
        return this.endTick;
    }

    TraceEntryImpl pushEntry(long startTick, Object messageSupplier, TimerImpl syncTimer, @Nullable AsyncTimer asyncTimer, @Nullable QueryData queryData, long queryExecutionCount) {
        TraceEntryImpl entry = new TraceEntryImpl(this.threadContext, this.activeEntry, messageSupplier, queryData, queryExecutionCount, startTick, syncTimer, asyncTimer);
        this.tailEntry.setNextTraceEntry(entry);
        this.tailEntry = entry;
        this.activeEntry = entry;
        return entry;
    }

    void popEntry(TraceEntryImpl entry, long endTick) {
        this.popEntrySafe(entry);
        if (entry == this.rootEntry) {
            this.endTick = endTick;
            this.completed = true;
        }
    }

    void popNonRootEntry(TraceEntryImpl entry) {
        this.popEntrySafe(entry);
    }

    TraceEntryImpl addErrorEntry(long startTick, long endTick, @Nullable Object messageSupplier, @Nullable QueryData queryData, ErrorMessage errorMessage) {
        TraceEntryImpl entry = TraceEntryImpl.createCompletedErrorEntry(this.threadContext, this.activeEntry, messageSupplier, queryData, errorMessage, startTick, endTick);
        this.tailEntry.setNextTraceEntry(entry);
        this.tailEntry = entry;
        return entry;
    }

    TraceEntryImpl getActiveEntry() {
        return this.activeEntry;
    }

    TraceEntryImpl getTailEntry() {
        return this.tailEntry;
    }

    boolean isEmpty() {
        return this.rootEntry == this.tailEntry;
    }

    private void popEntrySafe(TraceEntryImpl entry) {
        if (this.activeEntry != entry) {
            this.popEntryBailout(entry);
            return;
        }
        TraceEntryImpl parentTraceEntry = this.activeEntry.getParentTraceEntry();
        if (parentTraceEntry != null) {
            this.activeEntry = parentTraceEntry;
        }
    }

    private void popEntryBailout(TraceEntryImpl entry) {
        logger.error("found entry {} at top of stack when expecting entry {}", this.activeEntry, entry, new Exception("location stack trace"));
        for (TraceEntryImpl parentTraceEntry = this.activeEntry.getParentTraceEntry(); this.activeEntry != entry && parentTraceEntry != null; parentTraceEntry = parentTraceEntry.getParentTraceEntry()) {
            this.activeEntry = parentTraceEntry;
        }
    }
}

