/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.glowroot.agent.init.CollectorProxy;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.shaded.ch.qos.logback.classic.Level;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.IThrowableProxy;
import org.glowroot.agent.shaded.ch.qos.logback.classic.spi.StackTraceElementProxy;
import org.glowroot.agent.shaded.ch.qos.logback.core.UnsynchronizedAppenderBase;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.RateLimitedLogger;
import org.glowroot.agent.util.ThreadFactories;

class CollectorLogbackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(CollectorLogbackAppender.class);
    private static final int PENDING_LIMIT = 100;
    private final CollectorProxy collector;
    private final ExecutorService flushingExecutor;
    private final AtomicInteger pendingCount = new AtomicInteger();
    private final RateLimitedLogger backPressureLogger = new RateLimitedLogger(CollectorLogbackAppender.class);
    private final ThreadLocal<Boolean> inFlush = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    CollectorLogbackAppender(CollectorProxy collector) {
        this.collector = collector;
        this.flushingExecutor = Executors.newSingleThreadExecutor(ThreadFactories.create("Glowroot-Log-Flushing"));
    }

    @Override
    protected void append(ILoggingEvent event) {
        if (this.inFlush.get().booleanValue()) {
            return;
        }
        if (event.getLevel() == Level.DEBUG && event.getLoggerName().startsWith("org.glowroot.agent.shaded.io.grpc.")) {
            return;
        }
        if (event.getLoggerName().startsWith("org.glowroot.central.") || event.getLoggerName().startsWith("org.glowroot.ui.")) {
            return;
        }
        CollectorServiceOuterClass.LogMessage.LogEvent.Builder builder = CollectorServiceOuterClass.LogMessage.LogEvent.newBuilder().setTimestamp(event.getTimeStamp()).setLevel(CollectorLogbackAppender.toProto(event.getLevel())).setLoggerName(event.getLoggerName()).setMessage(event.getFormattedMessage());
        IThrowableProxy throwable = event.getThrowableProxy();
        if (throwable != null) {
            builder.setThrowable(CollectorLogbackAppender.toProto(throwable));
        }
        this.flush(builder.build());
    }

    private void flush(final CollectorServiceOuterClass.LogMessage.LogEvent logEvent) {
        if (this.pendingCount.get() >= 100) {
            this.backPressureLogger.warn("not sending log message to the central collector because of an excessive backlog of {} log messages already waiting to be sent", 100);
            return;
        }
        this.pendingCount.incrementAndGet();
        this.flushingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                CollectorLogbackAppender.this.inFlush.set(true);
                try {
                    CollectorLogbackAppender.this.collector.log(logEvent);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), e);
                }
                finally {
                    CollectorLogbackAppender.this.inFlush.set(false);
                    CollectorLogbackAppender.this.pendingCount.decrementAndGet();
                }
            }
        });
    }

    void close() throws InterruptedException {
        this.flushingExecutor.shutdown();
        this.flushingExecutor.shutdown();
        if (!this.flushingExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            throw new IllegalStateException("Could not terminate executor");
        }
    }

    private static CollectorServiceOuterClass.LogMessage.LogEvent.Level toProto(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return CollectorServiceOuterClass.LogMessage.LogEvent.Level.TRACE;
            }
            case 10000: {
                return CollectorServiceOuterClass.LogMessage.LogEvent.Level.DEBUG;
            }
            case 20000: {
                return CollectorServiceOuterClass.LogMessage.LogEvent.Level.INFO;
            }
            case 30000: {
                return CollectorServiceOuterClass.LogMessage.LogEvent.Level.WARN;
            }
            case 40000: {
                return CollectorServiceOuterClass.LogMessage.LogEvent.Level.ERROR;
            }
        }
        return CollectorServiceOuterClass.LogMessage.LogEvent.Level.NONE;
    }

    private static Proto.Throwable toProto(IThrowableProxy t) {
        Proto.Throwable.Builder builder = Proto.Throwable.newBuilder().setClassName(t.getClassName());
        String message = t.getMessage();
        if (message != null) {
            builder.setMessage(message);
        }
        for (StackTraceElementProxy element : t.getStackTraceElementProxyArray()) {
            builder.addStackTraceElement(ErrorMessage.toProto(element.getStackTraceElement()));
        }
        builder.setFramesInCommonWithEnclosing(t.getCommonFrames());
        IThrowableProxy cause = t.getCause();
        if (cause != null) {
            builder.setCause(CollectorLogbackAppender.toProto(cause));
        }
        for (IThrowableProxy suppressed : t.getSuppressed()) {
            builder.addSuppressed(CollectorLogbackAppender.toProto(suppressed));
        }
        return builder.build();
    }
}

