/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.init;

import java.io.File;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.collector.Collector;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.AgentConfigOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.CollectorServiceOuterClass;

public class CollectorProxy
implements Collector {
    @MonotonicNonNull
    private volatile Collector instance;
    private final CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void init(List<File> confDirs, CollectorServiceOuterClass.InitMessage.Environment environment, AgentConfigOuterClass.AgentConfig agentConfig, Collector.AgentConfigUpdater agentConfigUpdater) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectAggregates(Collector.AggregateReader aggregateReader) throws Exception {
        if (this.instance == null) {
            if (this.latch.await(2L, TimeUnit.MINUTES)) {
                Preconditions.checkNotNull(this.instance).collectAggregates(aggregateReader);
            }
        } else {
            this.instance.collectAggregates(aggregateReader);
        }
    }

    @Override
    public void collectGaugeValues(List<CollectorServiceOuterClass.GaugeValueMessage.GaugeValue> gaugeValues) throws Exception {
        if (this.instance == null) {
            if (this.latch.await(2L, TimeUnit.MINUTES)) {
                Preconditions.checkNotNull(this.instance).collectGaugeValues(gaugeValues);
            }
        } else {
            this.instance.collectGaugeValues(gaugeValues);
        }
    }

    @Override
    public void collectTrace(Collector.TraceReader traceReader) throws Exception {
        if (this.instance == null) {
            if (this.latch.await(2L, TimeUnit.MINUTES)) {
                Preconditions.checkNotNull(this.instance).collectTrace(traceReader);
            }
        } else {
            this.instance.collectTrace(traceReader);
        }
    }

    @Override
    public void log(CollectorServiceOuterClass.LogMessage.LogEvent logEvent) throws Exception {
        if (this.instance == null) {
            if (this.latch.await(2L, TimeUnit.MINUTES)) {
                Preconditions.checkNotNull(this.instance).log(logEvent);
            }
        } else {
            this.instance.log(logEvent);
        }
    }

    public void setInstance(Collector instance) {
        this.instance = instance;
        this.latch.countDown();
    }
}

