/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.glowroot.agent.impl.AggregateIntervalCollector;
import org.glowroot.agent.impl.TransactionProcessor;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ProfileCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.QueryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.ServiceCallCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameSummaryCollector;

public class LiveAggregateRepositoryImpl
implements LiveAggregateRepository {
    private final TransactionProcessor aggregator;

    public LiveAggregateRepositoryImpl(TransactionProcessor aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    public long mergeInOverallSummary(String agentId, LiveAggregateRepository.SummaryQuery query, OverallSummaryCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeOverallSummaryInto(collector, query.transactionType());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInTransactionNameSummaries(String agentId, LiveAggregateRepository.SummaryQuery query, TransactionNameSummaryCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeTransactionNameSummariesInto(collector, query.transactionType());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInOverallErrorSummary(String agentId, LiveAggregateRepository.SummaryQuery query, OverallErrorSummaryCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeOverallErrorSummaryInto(collector, query.transactionType());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInTransactionNameErrorSummaries(String agentId, LiveAggregateRepository.SummaryQuery query, TransactionNameErrorSummaryCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeTransactionNameErrorSummariesInto(collector, query.transactionType());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public Set<String> getTransactionTypes(String agentId) {
        return this.aggregator.getTransactionTypes();
    }

    @Override
    @Nullable
    public LiveAggregateRepository.LiveResult<LiveAggregateRepository.OverviewAggregate> getOverviewAggregates(String agentId, LiveAggregateRepository.AggregateQuery query) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (intervalCollectors.isEmpty()) {
            return null;
        }
        ArrayList<LiveAggregateRepository.OverviewAggregate> overviewAggregates = Lists.newArrayList();
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            LiveAggregateRepository.OverviewAggregate overviewAggregate = intervalCollector.getOverviewAggregate(query.transactionType(), query.transactionName());
            if (overviewAggregate != null) {
                overviewAggregates.add(overviewAggregate);
            }
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return new LiveAggregateRepository.LiveResult<LiveAggregateRepository.OverviewAggregate>(overviewAggregates, revisedTo);
    }

    @Override
    @Nullable
    public LiveAggregateRepository.LiveResult<LiveAggregateRepository.PercentileAggregate> getPercentileAggregates(String agentId, LiveAggregateRepository.AggregateQuery query) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (intervalCollectors.isEmpty()) {
            return null;
        }
        ArrayList<LiveAggregateRepository.PercentileAggregate> percentileAggregates = Lists.newArrayList();
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            LiveAggregateRepository.PercentileAggregate percentileAggregate = intervalCollector.getPercentileAggregate(query.transactionType(), query.transactionName());
            if (percentileAggregate != null) {
                percentileAggregates.add(percentileAggregate);
            }
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return new LiveAggregateRepository.LiveResult<LiveAggregateRepository.PercentileAggregate>(percentileAggregates, revisedTo);
    }

    @Override
    @Nullable
    public LiveAggregateRepository.LiveResult<LiveAggregateRepository.ThroughputAggregate> getThroughputAggregates(String agentId, LiveAggregateRepository.AggregateQuery query) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        if (intervalCollectors.isEmpty()) {
            return null;
        }
        ArrayList<LiveAggregateRepository.ThroughputAggregate> throughputAggregates = Lists.newArrayList();
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            LiveAggregateRepository.ThroughputAggregate throughputAggregate = intervalCollector.getThroughputAggregate(query.transactionType(), query.transactionName());
            if (throughputAggregate != null) {
                throughputAggregates.add(throughputAggregate);
            }
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return new LiveAggregateRepository.LiveResult<LiveAggregateRepository.ThroughputAggregate>(throughputAggregates, revisedTo);
    }

    @Override
    @Nullable
    public String getFullQueryText(String agentRollupId, String fullQueryTextSha1) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(0L, Long.MAX_VALUE);
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            String fullQueryText = intervalCollector.getFullQueryText(fullQueryTextSha1);
            if (fullQueryText == null) continue;
            return fullQueryText;
        }
        return null;
    }

    @Override
    public long mergeInQueries(String agentId, LiveAggregateRepository.AggregateQuery query, QueryCollector collector) throws IOException {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeQueriesInto(collector, query.transactionType(), query.transactionName());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInServiceCalls(String agentId, LiveAggregateRepository.AggregateQuery query, ServiceCallCollector collector) throws IOException {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeServiceCallsInto(collector, query.transactionType(), query.transactionName());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInMainThreadProfiles(String agentId, LiveAggregateRepository.AggregateQuery query, ProfileCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeMainThreadProfilesInto(collector, query.transactionType(), query.transactionName());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public long mergeInAuxThreadProfiles(String agentId, LiveAggregateRepository.AggregateQuery query, ProfileCollector collector) {
        List<AggregateIntervalCollector> intervalCollectors = this.aggregator.getOrderedIntervalCollectorsInRange(query.from(), query.to());
        long revisedTo = query.to();
        for (AggregateIntervalCollector intervalCollector : intervalCollectors) {
            intervalCollector.mergeAuxThreadProfilesInto(collector, query.transactionType(), query.transactionName());
            revisedTo = Math.min(revisedTo, intervalCollector.getCaptureTime() - 1L);
        }
        return revisedTo;
    }

    @Override
    public void clearInMemoryData() {
        this.aggregator.clearInMemoryData();
    }
}

