/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import org.glowroot.agent.config.ConfigService;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.live.HeapHistogramTool;
import org.glowroot.agent.live.JStackTool;
import org.glowroot.agent.live.ThreadDumpService;
import org.glowroot.agent.shaded.com.google.common.base.Joiner;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveJvmService;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;
import org.glowroot.agent.shaded.org.glowroot.common.util.Masking;
import org.glowroot.agent.shaded.org.glowroot.common.util.Throwables;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.JavaVersion;
import org.glowroot.agent.util.LazyPlatformMBeanServer;

public class LiveJvmServiceImpl
implements LiveJvmService {
    private static final Logger logger = LoggerFactory.getLogger(LiveJvmServiceImpl.class);
    private static final String HOT_SPOT_DIAGNOSTIC_MBEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    @Nullable
    private static final Long PROCESS_ID = LiveJvmServiceImpl.parseProcessId(ManagementFactory.getRuntimeMXBean().getName());
    private static final ImmutableSet<String> numericAttributeTypes = ImmutableSet.of("long", "int", "double", "float", "java.lang.Long", "java.lang.Integer", new String[]{"java.lang.Double", "java.lang.Float"});
    private final LazyPlatformMBeanServer lazyPlatformMBeanServer;
    private final ThreadDumpService threadDumpService;
    private final DownstreamServiceOuterClass.Availability threadAllocatedBytesAvailability;
    private final ConfigService configService;
    @Nullable
    private final File glowrootJarFile;
    private final Clock clock;

    public LiveJvmServiceImpl(LazyPlatformMBeanServer lazyPlatformMBeanServer, TransactionRegistry transactionRegistry, TraceCollector traceCollector, DownstreamServiceOuterClass.Availability threadAllocatedBytesAvailability, ConfigService configService, @Nullable File glowrootJarFile, Clock clock) {
        this.lazyPlatformMBeanServer = lazyPlatformMBeanServer;
        this.threadDumpService = new ThreadDumpService(transactionRegistry, traceCollector);
        this.threadAllocatedBytesAvailability = threadAllocatedBytesAvailability;
        this.configService = configService;
        this.glowrootJarFile = glowrootJarFile;
        this.clock = clock;
    }

    @Override
    public boolean isAvailable(String agentId) {
        return true;
    }

    @Override
    public DownstreamServiceOuterClass.ThreadDump getThreadDump(String agentId) {
        return this.threadDumpService.getThreadDump();
    }

    @Override
    public String getJstack(String agentId) throws Exception {
        if (JavaVersion.isJ9Jvm()) {
            throw new LiveJvmService.UnavailableDueToRunningInJ9JvmException();
        }
        if (JavaVersion.isGreaterThanOrEqualToJava8()) {
            return JStackTool.run(this.lazyPlatformMBeanServer);
        }
        long pid = Preconditions.checkNotNull(LiveJvmServiceImpl.getProcessId());
        return JStackTool.runPriorToJava8(pid, LiveJvmServiceImpl.allowAttachSelf(), this.glowrootJarFile);
    }

    @Override
    public long getAvailableDiskSpace(String agentId, String directory) throws LiveJvmService.DirectoryDoesNotExistException {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new LiveJvmService.DirectoryDoesNotExistException();
        }
        return dir.getFreeSpace();
    }

    @Override
    public DownstreamServiceOuterClass.HeapDumpFileInfo heapDump(String agentId, String directory) throws Exception {
        File dir = new File(directory);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new LiveJvmService.DirectoryDoesNotExistException();
        }
        File file = JavaVersion.isJ9Jvm() ? LiveJvmServiceImpl.j9HeapDump(dir) : this.heapDump(dir);
        return DownstreamServiceOuterClass.HeapDumpFileInfo.newBuilder().setFilePath(file.getAbsolutePath()).setFileSizeBytes(file.length()).build();
    }

    @Override
    public DownstreamServiceOuterClass.HeapHistogram heapHistogram(String agentId) throws Exception {
        if (JavaVersion.isJ9Jvm()) {
            throw new LiveJvmService.UnavailableDueToRunningInJ9JvmException();
        }
        if (JavaVersion.isGreaterThanOrEqualToJava8()) {
            return HeapHistogramTool.run(this.lazyPlatformMBeanServer);
        }
        long pid = Preconditions.checkNotNull(LiveJvmServiceImpl.getProcessId());
        return HeapHistogramTool.runPriorToJava8(pid, LiveJvmServiceImpl.allowAttachSelf(), this.glowrootJarFile);
    }

    @Override
    public boolean isExplicitGcDisabled(String agentId) throws Exception {
        if (JavaVersion.isGreaterThanOrEqualToJava10()) {
            return false;
        }
        boolean disabled = false;
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (jvmArg.equals("-XX:+DisableExplicitGC")) {
                disabled = true;
                continue;
            }
            if (!jvmArg.equals("-XX:-DisableExplicitGC")) continue;
            disabled = false;
        }
        return disabled;
    }

    @Override
    public void forceGC(String agentId) throws Exception {
        if (JavaVersion.isGreaterThanOrEqualToJava8()) {
            ObjectName objectName = ObjectName.getInstance("com.sun.management:type=DiagnosticCommand");
            this.lazyPlatformMBeanServer.invoke(objectName, "gcRun", new Object[]{null}, new String[]{"[Ljava.lang.String;"});
        } else {
            System.gc();
        }
    }

    @Override
    public DownstreamServiceOuterClass.MBeanDump getMBeanDump(String agentId, DownstreamServiceOuterClass.MBeanDumpRequest.MBeanDumpKind mbeanDumpKind, List<String> objectNames) throws Exception {
        switch (mbeanDumpKind) {
            case ALL_MBEANS_INCLUDE_ATTRIBUTES: {
                throw new UnsupportedOperationException("Not implemented yet");
            }
            case ALL_MBEANS_INCLUDE_ATTRIBUTES_FOR_SOME: {
                return DownstreamServiceOuterClass.MBeanDump.newBuilder().addAllMbeanInfo(this.getAllMBeanInfos(objectNames)).build();
            }
            case SOME_MBEANS_INCLUDE_ATTRIBUTES: {
                return DownstreamServiceOuterClass.MBeanDump.newBuilder().addAllMbeanInfo(this.getSomeMBeanInfos(objectNames)).build();
            }
        }
        throw new IllegalStateException("Unexpected mbean dump kind: " + mbeanDumpKind);
    }

    private File heapDump(File directory) throws Exception {
        File file = LiveJvmServiceImpl.generateHeapDumpFileName(directory, ".hprof");
        ObjectName objectName = ObjectName.getInstance(HOT_SPOT_DIAGNOSTIC_MBEAN_NAME);
        this.lazyPlatformMBeanServer.invoke(objectName, "dumpHeap", new Object[]{file.getAbsolutePath(), false}, new String[]{"java.lang.String", "boolean"});
        return file;
    }

    private List<DownstreamServiceOuterClass.MBeanDump.MBeanInfo> getAllMBeanInfos(List<String> includeAttrsForObjectNames) throws Exception {
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        Set<ObjectName> objectNames = this.lazyPlatformMBeanServer.queryNames(null, null, mbeanServers);
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanInfo> mbeanInfos = Lists.newArrayList();
        for (ObjectName objectName : objectNames) {
            String name = objectName.toString();
            if (includeAttrsForObjectNames.contains(name)) {
                mbeanInfos.add(DownstreamServiceOuterClass.MBeanDump.MBeanInfo.newBuilder().setObjectName(name).addAllAttribute(this.getMBeanAttributes(objectName)).build());
                continue;
            }
            mbeanInfos.add(DownstreamServiceOuterClass.MBeanDump.MBeanInfo.newBuilder().setObjectName(name).build());
        }
        return mbeanInfos;
    }

    private List<DownstreamServiceOuterClass.MBeanDump.MBeanInfo> getSomeMBeanInfos(List<String> includeObjectNames) throws Exception {
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanInfo> mbeanInfos = Lists.newArrayList();
        for (String objectName : includeObjectNames) {
            mbeanInfos.add(DownstreamServiceOuterClass.MBeanDump.MBeanInfo.newBuilder().setObjectName(objectName).addAllAttribute(this.getMBeanAttributes(new ObjectName(objectName))).build());
        }
        return mbeanInfos;
    }

    @Override
    public List<String> getMatchingMBeanObjectNames(String agentId, String partialObjectName, int limit) throws Exception {
        ObjectNameQueryExp queryExp = new ObjectNameQueryExp(partialObjectName);
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        Set<ObjectName> objectNames = this.lazyPlatformMBeanServer.queryNames(null, queryExp, mbeanServers);
        ArrayList<String> names = Lists.newArrayList();
        for (ObjectName objectName : objectNames) {
            String objectNameStr = objectName.toString();
            if (!queryExp.apply(objectNameStr)) continue;
            names.add(objectNameStr);
        }
        List<String> sortedNames = Ordering.natural().immutableSortedCopy(names);
        if (sortedNames.size() > limit) {
            sortedNames = sortedNames.subList(0, limit);
        }
        return sortedNames;
    }

    @Override
    public DownstreamServiceOuterClass.MBeanMeta getMBeanMeta(String agentId, String mbeanObjectName) throws Exception {
        Set<ObjectName> objectNames = this.getObjectNames(mbeanObjectName);
        ImmutableList<String> attributeNames = Ordering.natural().immutableSortedCopy(this.getAttributeNames(objectNames));
        return DownstreamServiceOuterClass.MBeanMeta.newBuilder().setNoMatchFound(objectNames.isEmpty()).addAllAttributeName(attributeNames).build();
    }

    @Override
    public Map<String, String> getSystemProperties(String agentId) {
        Map<String, String> systemProperties = ManagementFactory.getRuntimeMXBean().getSystemProperties();
        ImmutableList<String> maskSystemProperties = this.configService.getJvmConfig().maskSystemProperties();
        return Masking.maskSystemProperties(systemProperties, maskSystemProperties);
    }

    @Override
    public long getCurrentTime(String agentId) {
        return this.clock.currentTimeMillis();
    }

    @Override
    public DownstreamServiceOuterClass.Capabilities getCapabilities(String agentId) {
        return DownstreamServiceOuterClass.Capabilities.newBuilder().setThreadCpuTime(LiveJvmServiceImpl.getThreadCpuTimeAvailability()).setThreadContentionTime(LiveJvmServiceImpl.getThreadContentionAvailability()).setThreadAllocatedBytes(this.threadAllocatedBytesAvailability).build();
    }

    private List<DownstreamServiceOuterClass.MBeanDump.MBeanAttribute> getMBeanAttributes(ObjectName objectName) throws Exception {
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        MBeanInfo mBeanInfo = this.lazyPlatformMBeanServer.getMBeanInfo(objectName, mbeanServers);
        ImmutableList<Pattern> maskPatterns = Masking.buildPatternList(this.configService.getJvmConfig().maskMBeanAttributes());
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanAttribute> attributes = Lists.newArrayList();
        for (MBeanAttributeInfo attribute : mBeanInfo.getAttributes()) {
            Object value;
            String attributeName = attribute.getName();
            String fullAttributeName = objectName.toString() + ":" + attribute.getName();
            if (Masking.matchesAny(fullAttributeName, maskPatterns)) {
                value = "****";
            } else {
                try {
                    value = this.lazyPlatformMBeanServer.getAttribute(objectName, attributeName, mbeanServers);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), e);
                    value = "<" + Throwables.getBestMessage(e) + ">";
                }
            }
            attributes.add(DownstreamServiceOuterClass.MBeanDump.MBeanAttribute.newBuilder().setName(attributeName).setValue(LiveJvmServiceImpl.getMBeanAttributeValue(value)).build());
        }
        return attributes;
    }

    @Nullable
    public static Long getProcessId() {
        return PROCESS_ID;
    }

    @Nullable
    static Long parseProcessId(String runtimeName) {
        int index = runtimeName.indexOf(64);
        if (index > 0) {
            String pid = runtimeName.substring(0, index);
            try {
                return Long.parseLong(pid);
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
                return null;
            }
        }
        return null;
    }

    private static boolean allowAttachSelf() {
        if (JavaVersion.isJRockitJvm()) {
            return false;
        }
        if (JavaVersion.isOSX()) {
            return false;
        }
        return !JavaVersion.isGreaterThanOrEqualToJava9() || Boolean.getBoolean("jdk.attach.allowAttachSelf");
    }

    private static File j9HeapDump(File directory) throws Exception {
        File file = LiveJvmServiceImpl.generateHeapDumpFileName(directory, ".phd");
        Class<?> clazz = Class.forName("com.ibm.jvm.Dump");
        Method method = clazz.getMethod("heapDumpToFile", String.class);
        String actualHeapDumpPath = (String)Preconditions.checkNotNull(method.invoke(null, file.getAbsolutePath()));
        return new File(actualHeapDumpPath);
    }

    private static File generateHeapDumpFileName(File dir, String extension) {
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        File file = new File(dir, "heap-dump-" + timestamp + extension);
        int i = 1;
        while (file.exists()) {
            file = new File(dir, "heap-dump-" + timestamp + "-" + ++i + extension);
        }
        return file;
    }

    private static DownstreamServiceOuterClass.MBeanDump.MBeanValue getMBeanAttributeValue(@Nullable Object value) {
        if (value == null) {
            return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setNull(true).build();
        }
        if (value instanceof CompositeData) {
            return LiveJvmServiceImpl.getCompositeDataValue((CompositeData)value);
        }
        if (value instanceof TabularData) {
            return LiveJvmServiceImpl.getTabularDataValue((TabularData)value);
        }
        if (value.getClass().isArray()) {
            return LiveJvmServiceImpl.getArrayValue(value);
        }
        if (value instanceof Boolean) {
            return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setBoolean((Boolean)value).build();
        }
        if (value instanceof Long) {
            return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setLong((Long)value).build();
        }
        if (value instanceof Integer) {
            return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setLong(((Integer)value).intValue()).build();
        }
        if (value instanceof Number) {
            return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setDouble(((Number)value).doubleValue()).build();
        }
        return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setString(Preconditions.checkNotNull(value.toString())).build();
    }

    private static DownstreamServiceOuterClass.MBeanDump.MBeanValue getCompositeDataValue(CompositeData compositeData) {
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry> entries = Lists.newArrayList();
        for (String key : compositeData.getCompositeType().keySet()) {
            entries.add(DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry.newBuilder().setKey(key).setValue(LiveJvmServiceImpl.getMBeanAttributeValue(compositeData.get(key))).build());
        }
        return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setMap(DownstreamServiceOuterClass.MBeanDump.MBeanValueMap.newBuilder().addAllEntry(entries)).build();
    }

    private static DownstreamServiceOuterClass.MBeanDump.MBeanValue getTabularDataValue(TabularData tabularData) {
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry> outerEntries = Lists.newArrayList();
        Set<String> attributeNames = tabularData.getTabularType().getRowType().keySet();
        for (Object key : tabularData.keySet()) {
            List keyList = (List)key;
            String keyString = Joiner.on(", ").join(keyList);
            CompositeData compositeData = tabularData.get(keyList.toArray());
            ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry> innerEntries = Lists.newArrayList();
            for (String attributeName : attributeNames) {
                innerEntries.add(DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry.newBuilder().setKey(attributeName).setValue(LiveJvmServiceImpl.getMBeanAttributeValue(compositeData.get(attributeName))).build());
            }
            outerEntries.add(DownstreamServiceOuterClass.MBeanDump.MBeanValueMapEntry.newBuilder().setKey(keyString).setValue(DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setMap(DownstreamServiceOuterClass.MBeanDump.MBeanValueMap.newBuilder().addAllEntry(innerEntries)).build()).build());
        }
        return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setMap(DownstreamServiceOuterClass.MBeanDump.MBeanValueMap.newBuilder().addAllEntry(outerEntries)).build();
    }

    private static DownstreamServiceOuterClass.MBeanDump.MBeanValue getArrayValue(Object value) {
        int length = Array.getLength(value);
        ArrayList<DownstreamServiceOuterClass.MBeanDump.MBeanValue> values = Lists.newArrayListWithCapacity(length);
        for (int i = 0; i < length; ++i) {
            Object val = Array.get(value, i);
            values.add(LiveJvmServiceImpl.getMBeanAttributeValue(val));
        }
        return DownstreamServiceOuterClass.MBeanDump.MBeanValue.newBuilder().setList(DownstreamServiceOuterClass.MBeanDump.MBeanValueList.newBuilder().addAllValue(values)).build();
    }

    private Set<ObjectName> getObjectNames(String mbeanObjectName) throws Exception {
        ObjectName objectName = ObjectName.getInstance(mbeanObjectName);
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        if (objectName.isPattern()) {
            return this.lazyPlatformMBeanServer.queryNames(objectName, null, mbeanServers);
        }
        try {
            this.lazyPlatformMBeanServer.getMBeanInfo(objectName, mbeanServers);
        }
        catch (InstanceNotFoundException e) {
            return ImmutableSet.of();
        }
        return ImmutableSet.of(objectName);
    }

    private Set<String> getAttributeNames(Set<ObjectName> objectNames) throws Exception {
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        HashSet<String> attributeNames = Sets.newHashSet();
        for (ObjectName objectName : objectNames) {
            try {
                MBeanInfo mbeanInfo = this.lazyPlatformMBeanServer.getMBeanInfo(objectName, mbeanServers);
                attributeNames.addAll(this.getAttributeNames(mbeanInfo, objectName));
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return attributeNames;
    }

    private Set<String> getAttributeNames(MBeanInfo mbeanInfo, ObjectName objectName) throws Exception {
        List<MBeanServer> mbeanServers = this.lazyPlatformMBeanServer.findAllMBeanServers();
        HashSet<String> attributeNames = Sets.newHashSet();
        for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
            if (!attribute.isReadable()) continue;
            try {
                Object value = this.lazyPlatformMBeanServer.getAttribute(objectName, attribute.getName(), mbeanServers);
                LiveJvmServiceImpl.addNumericAttributes(attribute, value, attributeNames);
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return attributeNames;
    }

    private static void addNumericAttributes(MBeanAttributeInfo attribute, Object value, Set<String> attributeNames) {
        String attributeType = attribute.getType();
        if (numericAttributeTypes.contains(attributeType) || attributeType.equals("java.lang.Object") && value instanceof Number) {
            attributeNames.add(attribute.getName());
        } else if (attributeType.equals("java.lang.String") && value instanceof String) {
            try {
                Double.parseDouble((String)value);
                attributeNames.add(attribute.getName());
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
            }
        } else if (attributeType.equals(CompositeData.class.getName())) {
            Object openType = attribute.getDescriptor().getFieldValue("openType");
            CompositeType compositeType = null;
            if (openType instanceof CompositeType) {
                compositeType = (CompositeType)openType;
            } else if (openType == null && value instanceof CompositeDataSupport) {
                compositeType = ((CompositeDataSupport)value).getCompositeType();
            }
            if (compositeType != null) {
                attributeNames.addAll(LiveJvmServiceImpl.getCompositeTypeAttributeNames(attribute, value, compositeType));
            }
        }
    }

    private static List<String> getCompositeTypeAttributeNames(MBeanAttributeInfo attribute, Object compositeData, CompositeType compositeType) {
        ArrayList<String> attributeNames = Lists.newArrayList();
        for (String itemName : compositeType.keySet()) {
            Object val;
            Class<?> clazz;
            OpenType<?> itemType = compositeType.getType(itemName);
            if (itemType == null) continue;
            String className = itemType.getClassName();
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                logger.warn(e.getMessage(), e);
                continue;
            }
            if (Number.class.isAssignableFrom(clazz)) {
                attributeNames.add(attribute.getName() + '.' + itemName);
                continue;
            }
            if (clazz != String.class || !(compositeData instanceof CompositeData) || !((val = ((CompositeData)compositeData).get(itemName)) instanceof String)) continue;
            try {
                Double.parseDouble((String)val);
                attributeNames.add(attribute.getName() + '.' + itemName);
            }
            catch (NumberFormatException e) {
                logger.debug(e.getMessage(), e);
            }
        }
        return attributeNames;
    }

    private static DownstreamServiceOuterClass.Availability getThreadCpuTimeAvailability() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(false).setReason("java.lang.management.ThreadMXBean.isThreadCpuTimeSupported() returned false").build();
        }
        if (!threadMXBean.isThreadCpuTimeEnabled()) {
            return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(false).setReason("java.lang.management.ThreadMXBean.isThreadCpuTimeEnabled() returned false").build();
        }
        return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(true).build();
    }

    private static DownstreamServiceOuterClass.Availability getThreadContentionAvailability() {
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (!threadMXBean.isThreadContentionMonitoringSupported()) {
            return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(false).setReason("java.lang.management.ThreadMXBean.isThreadContentionMonitoringSupported() returned false").build();
        }
        if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
            return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(false).setReason("java.lang.management.ThreadMXBean.isThreadContentionMonitoringEnabled() returned false").build();
        }
        return DownstreamServiceOuterClass.Availability.newBuilder().setAvailable(true).build();
    }

    private static class ObjectNameQueryExp
    implements QueryExp {
        private final String textUpper;

        private ObjectNameQueryExp(String text) {
            this.textUpper = text.toUpperCase(Locale.ENGLISH);
        }

        @Override
        public boolean apply(ObjectName name) {
            return this.apply(name.toString());
        }

        private boolean apply(String nameStr) {
            return nameStr.toUpperCase(Locale.ENGLISH).contains(this.textUpper);
        }

        @Override
        public void setMBeanServer(MBeanServer s) {
        }
    }
}

