/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.live;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.impl.ThreadContextImpl;
import org.glowroot.agent.impl.TraceCollector;
import org.glowroot.agent.impl.Transaction;
import org.glowroot.agent.impl.TransactionRegistry;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.glowroot.common.util.NotAvailableAware;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.DownstreamServiceOuterClass;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;

class ThreadDumpService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadDumpService.class);
    private final TransactionRegistry transactionRegistry;
    private final TraceCollector traceCollector;

    ThreadDumpService(TransactionRegistry transactionRegistry, TraceCollector traceCollector) {
        this.transactionRegistry = transactionRegistry;
        this.traceCollector = traceCollector;
    }

    DownstreamServiceOuterClass.ThreadDump getThreadDump() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        List<ThreadContextImpl> activeThreadContexts = this.getActiveThreadContexts();
        ThreadInfo[] threadInfos = threadBean.getThreadInfo(threadBean.getAllThreadIds(), threadBean.isObjectMonitorUsageSupported(), false);
        long currentThreadId = Thread.currentThread().getId();
        HashMap<Long, ThreadInfo> unmatchedThreadInfos = Maps.newHashMap();
        ThreadInfo currentThreadInfo = null;
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            if (threadInfo.getThreadId() == currentThreadId) {
                currentThreadInfo = threadInfo;
                continue;
            }
            unmatchedThreadInfos.put(threadInfo.getThreadId(), threadInfo);
        }
        HashMap<String, TransactionThreadInfo> transactionThreadInfos = Maps.newHashMap();
        for (ThreadContextImpl threadContext : activeThreadContexts) {
            if (!threadContext.isActive()) continue;
            long threadId = threadContext.getThreadId();
            ThreadInfo threadInfo = (ThreadInfo)unmatchedThreadInfos.remove(threadId);
            if (threadInfo == null) {
                logger.warn("thread dump not captured for thread: {}", (Object)threadId);
                continue;
            }
            Transaction transaction = threadContext.getTransaction();
            String traceId = transaction.getTraceId();
            TransactionThreadInfo transactionThreadInfo = (TransactionThreadInfo)transactionThreadInfos.get(traceId);
            if (transactionThreadInfo == null) {
                transactionThreadInfo = new TransactionThreadInfo(transaction.getHeadline(), transaction.getTransactionType(), transaction.getTransactionName(), transaction.getDurationNanos(), transaction.getCpuNanos(), this.traceCollector.shouldStoreSlow(transaction));
                transactionThreadInfos.put(traceId, transactionThreadInfo);
            }
            transactionThreadInfo.threadInfos.add(threadInfo);
        }
        ArrayList<DownstreamServiceOuterClass.ThreadDump.Transaction> transactions = Lists.newArrayList();
        for (Map.Entry entry : transactionThreadInfos.entrySet()) {
            transactions.add(((TransactionThreadInfo)entry.getValue()).toProto((String)entry.getKey()));
        }
        ArrayList<DownstreamServiceOuterClass.ThreadDump.Thread> unmatchedThreads = Lists.newArrayList();
        for (ThreadInfo unmatchedThreadInfo : unmatchedThreadInfos.values()) {
            unmatchedThreads.add(ThreadDumpService.createProtobuf(unmatchedThreadInfo));
        }
        DownstreamServiceOuterClass.ThreadDump.Builder builder = DownstreamServiceOuterClass.ThreadDump.newBuilder().addAllTransaction(transactions).addAllUnmatchedThread(unmatchedThreads);
        if (currentThreadInfo != null) {
            builder.setThreadDumpingThread(ThreadDumpService.createProtobuf(currentThreadInfo));
        }
        return builder.build();
    }

    private List<ThreadContextImpl> getActiveThreadContexts() {
        ArrayList<ThreadContextImpl> activeThreadContexts = Lists.newArrayList();
        for (Transaction transaction : this.transactionRegistry.getTransactions()) {
            ThreadContextImpl mainThreadContext = transaction.getMainThreadContext();
            if (mainThreadContext.isActive()) {
                activeThreadContexts.add(mainThreadContext);
            }
            activeThreadContexts.addAll(transaction.getActiveAuxThreadContexts());
        }
        return activeThreadContexts;
    }

    private static DownstreamServiceOuterClass.ThreadDump.Thread createProtobuf(ThreadInfo threadInfo) {
        DownstreamServiceOuterClass.ThreadDump.Thread.Builder builder = DownstreamServiceOuterClass.ThreadDump.Thread.newBuilder().setName(threadInfo.getThreadName()).setId(threadInfo.getThreadId()).setState(threadInfo.getThreadState().name());
        LockInfo lockInfo = threadInfo.getLockInfo();
        if (lockInfo != null) {
            builder.setLockInfo(DownstreamServiceOuterClass.ThreadDump.LockInfo.newBuilder().setIdentityHashCode(lockInfo.getIdentityHashCode()).setClassName(lockInfo.getClassName()));
            long lockOwnerId = threadInfo.getLockOwnerId();
            if (lockOwnerId != -1L) {
                builder.setLockOwnerId(Proto.OptionalInt64.newBuilder().setValue(lockOwnerId));
            }
        }
        ArrayList<DownstreamServiceOuterClass.ThreadDump.StackTraceElement.Builder> stackTraceElements = Lists.newArrayList();
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            stackTraceElements.add(DownstreamServiceOuterClass.ThreadDump.StackTraceElement.newBuilder().setClassName(stackTraceElement.getClassName()).setMethodName(Strings.nullToEmpty(stackTraceElement.getMethodName())).setFileName(Strings.nullToEmpty(stackTraceElement.getFileName())).setLineNumber(stackTraceElement.getLineNumber()));
        }
        for (MonitorInfo lockedMonitor : threadInfo.getLockedMonitors()) {
            int lockedStackDepth = lockedMonitor.getLockedStackDepth();
            if (lockedStackDepth < 0) continue;
            ((DownstreamServiceOuterClass.ThreadDump.StackTraceElement.Builder)stackTraceElements.get(lockedStackDepth)).addMonitorInfo(DownstreamServiceOuterClass.ThreadDump.LockInfo.newBuilder().setClassName(lockedMonitor.getClassName()).setIdentityHashCode(lockedMonitor.getIdentityHashCode()));
        }
        for (DownstreamServiceOuterClass.ThreadDump.StackTraceElement.Builder stackTraceElement : stackTraceElements) {
            builder.addStackTraceElement(stackTraceElement);
        }
        return builder.build();
    }

    private static class TransactionThreadInfo {
        private final String headline;
        private final String transactionType;
        private final String transactionName;
        private final long durationNanos;
        private final long cpuNanos;
        private final boolean shouldStoreSlow;
        private final List<ThreadInfo> threadInfos = Lists.newArrayList();

        private TransactionThreadInfo(String headline, String transactionType, String transactionName, long durationNanos, long cpuNanos, boolean shouldStoreSlow) {
            this.headline = headline;
            this.transactionType = transactionType;
            this.transactionName = transactionName;
            this.durationNanos = durationNanos;
            this.cpuNanos = cpuNanos;
            this.shouldStoreSlow = shouldStoreSlow;
        }

        private DownstreamServiceOuterClass.ThreadDump.Transaction toProto(String traceId) {
            DownstreamServiceOuterClass.ThreadDump.Transaction.Builder builder = DownstreamServiceOuterClass.ThreadDump.Transaction.newBuilder().setHeadline(this.headline).setTransactionType(this.transactionType).setTransactionName(this.transactionName).setDurationNanos(this.durationNanos);
            if (!NotAvailableAware.isNA(this.cpuNanos)) {
                builder.setCpuNanos(Proto.OptionalInt64.newBuilder().setValue(this.cpuNanos));
            }
            if (this.shouldStoreSlow) {
                builder.setTraceId(traceId);
            }
            for (ThreadInfo auxThreadInfo : this.threadInfos) {
                builder.addThread(ThreadDumpService.createProtobuf(auxThreadInfo));
            }
            return builder.build();
        }
    }
}

