/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import java.util.ArrayList;
import org.glowroot.agent.model.ErrorMessage;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Objects;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.ParametersAreNonnullByDefault;
import org.glowroot.agent.shaded.javax.annotation.concurrent.Immutable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.shaded.org.glowroot.wire.api.model.Proto;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorMessage", generator="Immutables")
@Immutable
public final class ImmutableErrorMessage
extends ErrorMessage {
    private final String message;
    @Nullable
    private final Proto.Throwable throwable;

    private ImmutableErrorMessage(String message, @Nullable Proto.Throwable throwable) {
        this.message = Preconditions.checkNotNull(message, "message");
        this.throwable = throwable;
    }

    private ImmutableErrorMessage(ImmutableErrorMessage original, String message, @Nullable Proto.Throwable throwable) {
        this.message = message;
        this.throwable = throwable;
    }

    @Override
    @JsonProperty(value="message")
    public String message() {
        return this.message;
    }

    @Override
    @JsonProperty(value="throwable")
    @Nullable
    public Proto.Throwable throwable() {
        return this.throwable;
    }

    public final ImmutableErrorMessage withMessage(String value) {
        String newValue = Preconditions.checkNotNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorMessage(this, newValue, this.throwable);
    }

    public final ImmutableErrorMessage withThrowable(@Nullable Proto.Throwable value) {
        if (this.throwable == value) {
            return this;
        }
        return new ImmutableErrorMessage(this, this.message, value);
    }

    public boolean equals(@org.glowroot.agent.shaded.javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorMessage && this.equalTo((ImmutableErrorMessage)another);
    }

    private boolean equalTo(ImmutableErrorMessage another) {
        return this.message.equals(another.message) && Objects.equal(this.throwable, another.throwable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.throwable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ErrorMessage").omitNullValues().add("message", this.message).add("throwable", this.throwable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorMessage fromJson(Json json) {
        Builder builder = ImmutableErrorMessage.builder();
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.throwable != null) {
            builder.throwable(json.throwable);
        }
        return builder.build();
    }

    public static ImmutableErrorMessage of(String message, @Nullable Proto.Throwable throwable) {
        return new ImmutableErrorMessage(message, throwable);
    }

    public static ImmutableErrorMessage copyOf(ErrorMessage instance) {
        if (instance instanceof ImmutableErrorMessage) {
            return (ImmutableErrorMessage)instance;
        }
        return ImmutableErrorMessage.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorMessage", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE = 1L;
        private long initBits = 1L;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private String message;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        private Proto.Throwable throwable;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ErrorMessage instance) {
            Preconditions.checkNotNull(instance, "instance");
            this.message(instance.message());
            Proto.Throwable throwableValue = instance.throwable();
            if (throwableValue != null) {
                this.throwable(throwableValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Preconditions.checkNotNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder throwable(@Nullable Proto.Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public ImmutableErrorMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorMessage(null, this.message, this.throwable);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build ErrorMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorMessage", generator="Immutables")
    static final class Json
    extends ErrorMessage {
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        String message;
        @org.glowroot.agent.shaded.javax.annotation.Nullable
        Proto.Throwable throwable;

        Json() {
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="throwable")
        public void setThrowable(@Nullable Proto.Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public String message() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Proto.Throwable throwable() {
            throw new UnsupportedOperationException();
        }
    }
}

