/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.model;

import org.glowroot.agent.model.QueryData;
import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.shaded.org.checkerframework.checker.nullness.qual.Nullable;

public abstract class QueryEntryBase
implements QueryEntry {
    @Nullable
    private final QueryData queryData;
    private long currRow = -1L;
    private long maxRow;

    protected QueryEntryBase(@Nullable QueryData queryData, long startTick, long queryExecutionCount) {
        this.queryData = queryData;
        if (queryData != null && queryExecutionCount != -1L) {
            queryData.start(startTick, queryExecutionCount);
        }
    }

    public void extendQueryData(long startTick) {
        if (this.queryData != null) {
            this.queryData.extend(startTick);
        }
    }

    public void endQueryData(long endTick) {
        if (this.queryData != null) {
            this.queryData.end(endTick);
        }
    }

    @Override
    public void rowNavigationAttempted() {
        if (this.currRow == -1L) {
            this.currRow = 0L;
            if (this.queryData != null) {
                this.queryData.setHasTotalRows();
            }
        }
    }

    @Override
    public void incrementCurrRow() {
        if (this.currRow == -1L) {
            this.currRow = 1L;
            this.maxRow = 1L;
            if (this.queryData != null) {
                this.queryData.incrementRowCount(1L);
            }
        } else if (this.currRow == this.maxRow) {
            ++this.currRow;
            this.maxRow = this.currRow;
            if (this.queryData != null) {
                this.queryData.incrementRowCount(1L);
            }
        } else {
            ++this.currRow;
        }
    }

    @Override
    public void setCurrRow(long row) {
        if (row > this.maxRow) {
            if (this.queryData != null) {
                this.queryData.incrementRowCount(row - this.maxRow);
            }
            this.maxRow = row;
        }
        this.currRow = row;
    }

    protected boolean isRowNavigationAttempted() {
        return this.currRow != -1L;
    }

    protected long getRowCount() {
        return this.maxRow;
    }

    @Nullable
    protected QueryData getQueryData() {
        return this.queryData;
    }

    @Nullable
    protected String getQueryText() {
        return this.queryData == null ? null : this.queryData.getQueryText();
    }
}

