/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.executor;

import java.util.concurrent.Callable;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class CallableWrapper<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final AuxThreadContext auxContext;

    public CallableWrapper(Callable<V> delegate, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.auxContext = auxContext;
    }

    @Override
    public V call() {
        V v;
        TraceEntry traceEntry = this.auxContext.start();
        try {
            v = this.delegate.call();
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw CallableWrapper.rethrow(t);
        }
        traceEntry.end();
        return v;
    }

    private static RuntimeException rethrow(Throwable t) {
        CallableWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

