/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.httpclient._.DirectExecutor;
import org.glowroot.agent.plugin.httpclient._.Uris;

public class AsyncHttpClientAspect2x {

    private static class ExecuteRequestListener<T extends ListenableFutureMixin & Future<?>>
    implements Runnable {
        private final AsyncTraceEntry asyncTraceEntry;
        private final T future;

        private ExecuteRequestListener(AsyncTraceEntry asyncTraceEntry, T future) {
            this.asyncTraceEntry = asyncTraceEntry;
            this.future = future;
        }

        @Override
        public void run() {
            Throwable t = this.getException();
            if (t == null) {
                this.asyncTraceEntry.end();
            } else {
                this.asyncTraceEntry.endWithError(t);
            }
        }

        @Nullable
        private Throwable getException() {
            this.future.glowroot$setIgnoreGet(true);
            try {
                ((Future)this.future).get();
            }
            catch (Throwable t) {
                Throwable throwable = t;
                return throwable;
            }
            finally {
                this.future.glowroot$setIgnoreGet(false);
            }
            return null;
        }

        /* synthetic */ ExecuteRequestListener(AsyncTraceEntry x0, ListenableFutureMixin x1, 1 x2) {
            this(x0, x1);
        }
    }

    @Pointcut(className="java.util.concurrent.Future", subTypeRestriction="org.asynchttpclient.ListenableFuture", methodName="get", methodParameterTypes={".."}, suppressionKey="wait-on-future")
    public static class FutureGetAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindReceiver ListenableFutureMixin future) {
            return !future.glowroot$getIgnoreGet();
        }

        @OnBefore
        @Nullable
        public static Timer onBefore(ThreadContext threadContext, @BindReceiver ListenableFutureMixin future) {
            AsyncTraceEntry asyncTraceEntry = future.glowroot$getAsyncTraceEntry();
            if (asyncTraceEntry == null) {
                return null;
            }
            return asyncTraceEntry.extendSyncTimer(threadContext);
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer syncTimer) {
            if (syncTimer != null) {
                syncTimer.stop();
            }
        }
    }

    @Pointcut(className="org.asynchttpclient.AsyncHttpClient", methodName="executeRequest", methodParameterTypes={"org.asynchttpclient.Request", ".."}, methodReturnType="org.asynchttpclient.ListenableFuture", nestingGroup="http-client", timerName="http client request")
    public static class ExecuteRequestAdvice {
        private static final TimerName timerName = Agent.getTimerName(ExecuteRequestAdvice.class);

        @OnBefore
        @Nullable
        public static AsyncTraceEntry onBefore(ThreadContext context, @BindParameter @Nullable Request request) {
            if (request == null) {
                return null;
            }
            String method = request.getMethod();
            method = method == null ? "" : method + " ";
            String url = request.getUrl();
            if (url == null) {
                url = "";
            }
            return context.startAsyncServiceCallEntry("HTTP", method + Uris.stripQueryString(url), MessageSupplier.create("http client request: {}{}", method, url), timerName);
        }

        @OnReturn
        public static <T extends ListenableFutureMixin & ListenableFuture<?>> void onReturn(@BindReturn @Nullable T future, @BindTraveler @Nullable AsyncTraceEntry asyncTraceEntry) {
            if (asyncTraceEntry == null) {
                return;
            }
            asyncTraceEntry.stopSyncTimer();
            if (future == null) {
                asyncTraceEntry.end();
                return;
            }
            future.glowroot$setAsyncTraceEntry(asyncTraceEntry);
            ((ListenableFuture<?>)future).addListener(new ExecuteRequestListener(asyncTraceEntry, future, null), (Executor)DirectExecutor.INSTANCE);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable AsyncTraceEntry asyncTraceEntry) {
            if (asyncTraceEntry != null) {
                asyncTraceEntry.stopSyncTimer();
                asyncTraceEntry.endWithError(t);
            }
        }
    }

    public static interface ListenableFutureMixin {
        @Nullable
        public AsyncTraceEntry glowroot$getAsyncTraceEntry();

        public void glowroot$setAsyncTraceEntry(@Nullable AsyncTraceEntry var1);

        public boolean glowroot$getIgnoreGet();

        public void glowroot$setIgnoreGet(boolean var1);
    }

    @Mixin(value={"org.asynchttpclient.ListenableFuture"})
    public static abstract class ListenableFutureImpl
    implements ListenableFutureMixin {
        @Nullable
        private transient AsyncTraceEntry glowroot$asyncTraceEntry;
        private transient boolean glowroot$ignoreGet;

        @Override
        @Nullable
        public AsyncTraceEntry glowroot$getAsyncTraceEntry() {
            return this.glowroot$asyncTraceEntry;
        }

        @Override
        public void glowroot$setAsyncTraceEntry(@Nullable AsyncTraceEntry asyncTraceEntry) {
            this.glowroot$asyncTraceEntry = asyncTraceEntry;
        }

        @Override
        public boolean glowroot$getIgnoreGet() {
            return this.glowroot$ignoreGet;
        }

        @Override
        public void glowroot$setIgnoreGet(boolean ignoreGet) {
            this.glowroot$ignoreGet = ignoreGet;
        }
    }
}

