/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.httpclient._.Uris;

public class HttpURLConnectionAspect {
    private static final Logger logger = Logger.getLogger(HttpURLConnectionAspect.class);
    private static final AtomicBoolean inputStreamIssueAlreadyLogged = new AtomicBoolean();
    private static final AtomicBoolean outputStreamIssueAlreadyLogged = new AtomicBoolean();

    @Pointcut(className="java.io.OutputStream", subTypeRestriction="sun.net.www.protocol.http.HttpURLConnection$StreamingOutputStream|sun.net.www.http.PosterOutputStream|weblogic.utils.io.UnsyncByteArrayOutputStream", methodName="*", methodParameterTypes={".."})
    public static class StreamingOutputStreamAdvice {
        @OnBefore
        @Nullable
        public static Timer onBefore(@BindReceiver OutputStream outputStream) {
            if (!(outputStream instanceof HasTraceEntryMixin)) {
                return null;
            }
            TraceEntry traceEntry = ((HasTraceEntryMixin)((Object)outputStream)).glowroot$getTraceEntry();
            if (traceEntry == null) {
                return null;
            }
            return traceEntry.extend();
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Pointcut(className="java.io.InputStream", subTypeRestriction="sun.net.www.protocol.http.HttpURLConnection$HttpInputStream|weblogic.net.http.KeepAliveStream", methodName="*", methodParameterTypes={".."})
    public static class HttpInputStreamAdvice {
        @OnBefore
        @Nullable
        public static Timer onBefore(@BindReceiver InputStream inputStream) {
            if (!(inputStream instanceof HasTraceEntryMixin)) {
                return null;
            }
            TraceEntry traceEntry = ((HasTraceEntryMixin)((Object)inputStream)).glowroot$getTraceEntry();
            if (traceEntry == null) {
                return null;
            }
            return traceEntry.extend();
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="getOutputStream", methodParameterTypes={}, nestingGroup="http-client")
    public static class GetOutputStreamAdvice {
        @OnBefore
        @Nullable
        public static TraceEntryOrTimer onBefore(ThreadContext threadContext, @BindReceiver HttpURLConnection httpURLConnection) {
            return ConnectAdvice.onBefore(threadContext, httpURLConnection, true);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable Object returnValue, @BindReceiver HttpURLConnection httpURLConnection, @BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            if (httpURLConnection instanceof HasTraceEntryMixin) {
                if (returnValue instanceof HasTraceEntryMixin) {
                    TraceEntry traceEntry = ((HasTraceEntryMixin)((Object)httpURLConnection)).glowroot$getTraceEntry();
                    ((HasTraceEntryMixin)returnValue).glowroot$setTraceEntry(traceEntry);
                } else if (returnValue != null && !outputStreamIssueAlreadyLogged.getAndSet(true)) {
                    logger.info("found non-instrumented http url connection output stream, please report to the Glowroot project: {}", (Object)returnValue.getClass().getName());
                }
            }
            ConnectAdvice.onReturn(entryOrTimer);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            ConnectAdvice.onThrow(t, entryOrTimer);
        }
    }

    @Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="getInputStream", methodParameterTypes={}, nestingGroup="http-client")
    public static class GetInputStreamAdvice {
        @OnBefore
        @Nullable
        public static TraceEntryOrTimer onBefore(ThreadContext threadContext, @BindReceiver HttpURLConnection httpURLConnection) {
            return ConnectAdvice.onBefore(threadContext, httpURLConnection, false);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable Object returnValue, @BindReceiver HttpURLConnection httpURLConnection, @BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            if (httpURLConnection instanceof HasTraceEntryMixin) {
                if (returnValue instanceof HasTraceEntryMixin) {
                    TraceEntry traceEntry = ((HasTraceEntryMixin)((Object)httpURLConnection)).glowroot$getTraceEntry();
                    ((HasTraceEntryMixin)returnValue).glowroot$setTraceEntry(traceEntry);
                } else if (returnValue != null && !inputStreamIssueAlreadyLogged.getAndSet(true)) {
                    logger.info("found non-instrumented http url connection input stream, please report to the Glowroot project: {}", (Object)returnValue.getClass().getName());
                }
            }
            ConnectAdvice.onReturn(entryOrTimer);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            ConnectAdvice.onThrow(t, entryOrTimer);
        }
    }

    @Pointcut(className="java.net.URLConnection", subTypeRestriction="java.net.HttpURLConnection", methodName="connect", methodParameterTypes={}, nestingGroup="http-client", timerName="http client")
    public static class ConnectAdvice {
        private static final TimerName timerName = Agent.getTimerName(ConnectAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntryOrTimer onBefore(ThreadContext threadContext, @BindReceiver HttpURLConnection httpURLConnection) {
            return ConnectAdvice.onBefore(threadContext, httpURLConnection, false);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            if (entryOrTimer != null) {
                entryOrTimer.onReturn();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntryOrTimer entryOrTimer) {
            if (entryOrTimer != null) {
                entryOrTimer.onThrow(t);
            }
        }

        @Nullable
        private static TraceEntryOrTimer onBefore(ThreadContext threadContext, HttpURLConnection httpURLConnection, boolean overrideGetWithPost) {
            if (!(httpURLConnection instanceof HasTraceEntryMixin)) {
                return null;
            }
            TraceEntry traceEntry = ((HasTraceEntryMixin)((Object)httpURLConnection)).glowroot$getTraceEntry();
            if (traceEntry != null) {
                return new TraceEntryOrTimer(traceEntry.extend());
            }
            String method = httpURLConnection.getRequestMethod();
            method = method == null ? "" : (overrideGetWithPost && method.equals("GET") ? "POST " : method + " ");
            URL urlObj = httpURLConnection.getURL();
            String url = urlObj == null ? "" : urlObj.toString();
            traceEntry = threadContext.startServiceCallEntry("HTTP", method + Uris.stripQueryString(url), MessageSupplier.create("http client request: {}{}", method, url), timerName);
            ((HasTraceEntryMixin)((Object)httpURLConnection)).glowroot$setTraceEntry(traceEntry);
            return new TraceEntryOrTimer(traceEntry);
        }
    }

    private static class TraceEntryOrTimer {
        @Nullable
        private final TraceEntry traceEntry;
        @Nullable
        private final Timer timer;

        private TraceEntryOrTimer(TraceEntry traceEntry) {
            this.traceEntry = traceEntry;
            this.timer = null;
        }

        private TraceEntryOrTimer(Timer timer) {
            this.timer = timer;
            this.traceEntry = null;
        }

        private void onReturn() {
            if (this.traceEntry != null) {
                this.traceEntry.end();
            } else if (this.timer != null) {
                this.timer.stop();
            }
        }

        private void onThrow(Throwable t) {
            if (this.traceEntry != null) {
                this.traceEntry.endWithError(t);
            } else if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    public static interface HasTraceEntryMixin {
        @Nullable
        public TraceEntry glowroot$getTraceEntry();

        public void glowroot$setTraceEntry(@Nullable TraceEntry var1);

        public boolean glowroot$hasTraceEntry();
    }

    @Mixin(value={"java.net.HttpURLConnection", "sun.net.www.protocol.http.HttpURLConnection$HttpInputStream", "sun.net.www.protocol.http.HttpURLConnection$StreamingOutputStream", "sun.net.www.http.PosterOutputStream", "weblogic.net.http.KeepAliveStream", "weblogic.utils.io.UnsyncByteArrayOutputStream"})
    public static class HasTraceEntryImpl
    implements HasTraceEntryMixin {
        @Nullable
        private transient TraceEntry glowroot$traceEntry;

        @Override
        @Nullable
        public TraceEntry glowroot$getTraceEntry() {
            return this.glowroot$traceEntry;
        }

        @Override
        public void glowroot$setTraceEntry(@Nullable TraceEntry traceEntry) {
            this.glowroot$traceEntry = traceEntry;
        }

        @Override
        public boolean glowroot$hasTraceEntry() {
            return this.glowroot$traceEntry != null;
        }
    }
}

