/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.httpclient;

import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import org.glowroot.agent.plugin.api.AsyncTraceEntry;
import org.glowroot.agent.plugin.api.AuxThreadContext;
import org.glowroot.agent.plugin.api.TraceEntry;

public class OkHttp2xCallbackWrapper
implements Callback {
    private final Callback delegate;
    private final AsyncTraceEntry asyncTraceEntry;
    private final AuxThreadContext auxContext;

    public OkHttp2xCallbackWrapper(Callback delegate, AsyncTraceEntry asyncTraceEntry, AuxThreadContext auxContext) {
        this.delegate = delegate;
        this.asyncTraceEntry = asyncTraceEntry;
        this.auxContext = auxContext;
    }

    public void onFailure(Request request, IOException exception) {
        this.asyncTraceEntry.endWithError(exception);
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.onFailure(request, exception);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw OkHttp2xCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    public void onResponse(Response response) throws IOException {
        this.asyncTraceEntry.end();
        TraceEntry traceEntry = this.auxContext.start();
        try {
            this.delegate.onResponse(response);
        }
        catch (Throwable t) {
            traceEntry.endWithError(t);
            throw OkHttp2xCallbackWrapper.rethrow(t);
        }
        traceEntry.end();
    }

    private static RuntimeException rethrow(Throwable t) {
        OkHttp2xCallbackWrapper.throwsUnchecked(t);
        throw new AssertionError();
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable t) throws T {
        throw t;
    }
}

