/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.javahttpserver;

import java.net.InetSocketAddress;
import java.net.URI;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.OptionalThreadContext;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.FastThreadLocal;
import org.glowroot.agent.plugin.api.weaving.BindParameter;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.javahttpserver.DetailCapture;
import org.glowroot.agent.plugin.javahttpserver.HttpHandlerMessageSupplier;
import org.glowroot.agent.plugin.javahttpserver.JavaHttpServerPluginProperties;
import org.glowroot.agent.plugin.javahttpserver.Strings;

public class HttpHandlerAspect {
    private static final FastThreadLocal<String> sendError = new FastThreadLocal();

    @Pointcut(className="com.sun.net.httpserver.HttpExchange", methodName="getPrincipal", methodParameterTypes={}, methodReturnType="com.sun.net.httpserver.HttpPrincipal", nestingGroup="handler-inner-call")
    public static class GetPrincipalAdvice {
        @OnReturn
        public static void onReturn(@BindReturn @Nullable Principal principal, ThreadContext context) {
            if (principal != null) {
                context.setTransactionUser(principal.getName(), -100);
            }
        }
    }

    @Pointcut(className="com.sun.net.httpserver.HttpExchange", methodName="sendResponseHeaders", methodParameterTypes={"int", "long"}, nestingGroup="handler-inner-call")
    public static class SendResponseHeadersAdvice {
        @IsEnabled
        public static boolean isEnabled(@BindParameter Integer statusCode) {
            return statusCode >= 500 || JavaHttpServerPluginProperties.traceErrorOn4xxResponseCode() && statusCode >= 400;
        }

        @OnAfter
        public static void onAfter(ThreadContext context, @BindParameter Integer statusCode) {
            FastThreadLocal.Holder<String> errorMessageHolder = sendError.getHolder();
            if (errorMessageHolder.get() == null) {
                context.addErrorEntry("sendResponseHeaders, HTTP status code " + statusCode);
                errorMessageHolder.set("sendResponseHeaders, HTTP status code " + statusCode);
            }
        }
    }

    @Pointcut(className="com.sun.net.httpserver.Filter", methodName="doFilter", methodParameterTypes={"com.sun.net.httpserver.HttpExchange", "com.sun.net.httpserver.Filter$Chain"}, nestingGroup="outer-handler-or-filter", timerName="http request")
    public static class DoFilterAdvice {
        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable HttpExchange exchange) {
            return HandleAdvice.onBeforeCommon(context, exchange);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable HttpExchange exchange) {
            HandleAdvice.onReturn(traceEntry, exchange);
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable HttpExchange exchange) {
            HandleAdvice.onThrow(t, traceEntry, exchange);
        }
    }

    @Pointcut(className="com.sun.net.httpserver.HttpHandler", methodName="handle", methodParameterTypes={"com.sun.net.httpserver.HttpExchange"}, nestingGroup="outer-handler-or-filter", timerName="http request")
    public static class HandleAdvice {
        private static final TimerName timerName = Agent.getTimerName(HandleAdvice.class);

        @OnBefore
        @Nullable
        public static TraceEntry onBefore(OptionalThreadContext context, @BindParameter @Nullable HttpExchange exchange) {
            return HandleAdvice.onBeforeCommon(context, exchange);
        }

        @OnReturn
        public static void onReturn(@BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable HttpExchange exchange) {
            if (traceEntry == null) {
                return;
            }
            FastThreadLocal.Holder errorMessageHolder = sendError.getHolder();
            String errorMessage = (String)errorMessageHolder.get();
            HandleAdvice.setResponseHeaders(exchange, traceEntry.getMessageSupplier());
            if (errorMessage != null) {
                traceEntry.endWithError(errorMessage);
                errorMessageHolder.set(null);
            } else {
                traceEntry.end();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler @Nullable TraceEntry traceEntry, @BindParameter @Nullable HttpExchange exchange) {
            if (traceEntry == null) {
                return;
            }
            sendError.set(null);
            HandleAdvice.setResponseHeaders(exchange, traceEntry.getMessageSupplier());
            traceEntry.endWithError(t);
        }

        private static void setResponseHeaders(@Nullable HttpExchange exchange, @Nullable Object messageSupplier) {
            if (exchange != null && messageSupplier instanceof HttpHandlerMessageSupplier) {
                ((HttpHandlerMessageSupplier)messageSupplier).setResponseHeaders(DetailCapture.captureResponseHeaders(exchange));
            }
        }

        @Nullable
        private static TraceEntry onBeforeCommon(OptionalThreadContext context, @Nullable HttpExchange exchange) {
            String transactionNameOverride;
            String transactionTypeHeader;
            if (exchange == null) {
                return null;
            }
            String requestUri = HandleAdvice.getRequestURI(exchange.getRequestURI());
            String requestQueryString = HandleAdvice.getRequestQueryString(exchange.getRequestURI());
            String requestMethod = Strings.nullToEmpty(exchange.getRequestMethod());
            Map<String, Object> requestHeaders = DetailCapture.captureRequestHeaders(exchange);
            String requestRemoteAddr = DetailCapture.captureRequestRemoteAddr(exchange);
            String requestRemoteHost = DetailCapture.captureRequestRemoteHost(exchange);
            HttpHandlerMessageSupplier messageSupplier = new HttpHandlerMessageSupplier(requestMethod, requestUri, requestQueryString, requestHeaders, requestRemoteAddr, requestRemoteHost);
            String transactionType = "Web";
            boolean setWithCoreMaxPriority = false;
            Headers headers = exchange.glowroot$getRequestHeaders();
            if (headers != null && "Synthetic".equals(transactionTypeHeader = headers.getFirst("Glowroot-Transaction-Type"))) {
                transactionType = transactionTypeHeader;
                setWithCoreMaxPriority = true;
            }
            TraceEntry traceEntry = context.startTransaction(transactionType, requestUri, messageSupplier, timerName);
            if (setWithCoreMaxPriority) {
                context.setTransactionType(transactionType, 1000000);
            }
            if (headers != null && (transactionNameOverride = headers.getFirst("Glowroot-Transaction-Name")) != null) {
                context.setTransactionName(transactionNameOverride, 1000000);
            }
            return traceEntry;
        }

        private static String getRequestURI(@Nullable URI uri) {
            if (uri != null) {
                return Strings.nullToEmpty(uri.getPath());
            }
            return "";
        }

        @Nullable
        private static String getRequestQueryString(@Nullable URI uri) {
            if (uri != null) {
                return uri.getQuery();
            }
            return null;
        }
    }

    @Shim(value={"com.sun.net.httpserver.Headers"})
    public static interface Headers
    extends Map<String, List<String>> {
        @Nullable
        public String getFirst(String var1);
    }

    @Shim(value={"com.sun.net.httpserver.HttpExchange"})
    public static interface HttpExchange {
        @Nullable
        public URI getRequestURI();

        @Nullable
        public String getRequestMethod();

        @Shim(value={"com.sun.net.httpserver.Headers getRequestHeaders()"})
        @Nullable
        public Headers glowroot$getRequestHeaders();

        @Shim(value={"com.sun.net.httpserver.Headers getResponseHeaders()"})
        @Nullable
        public Headers glowroot$getResponseHeaders();

        @Nullable
        public InetSocketAddress getRemoteAddress();
    }
}

