/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.javahttpserver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.config.ConfigListener;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.util.ImmutableList;

class JavaHttpServerPluginProperties {
    private static final String CAPTURE_REQUEST_HEADER_PROPERTY_NAME = "captureRequestHeaders";
    private static final String MASK_REQUEST_HEADER_PROPERTY_NAME = "maskRequestHeaders";
    private static final String CAPTURE_REQUEST_REMOTE_ADDR_PROPERTY_NAME = "captureRequestRemoteAddr";
    private static final String CAPTURE_REQUEST_REMOTE_HOST_PROPERTY_NAME = "captureRequestRemoteHost";
    private static final String CAPTURE_RESPONSE_HEADER_PROPERTY_NAME = "captureResponseHeaders";
    private static final String TRACE_ERROR_ON_4XX_RESPONSE_CODE = "traceErrorOn4xxResponseCode";
    private static final ConfigService configService = Agent.getConfigService("java-http-server");
    private static List<Pattern> captureRequestHeaders = Collections.emptyList();
    private static List<Pattern> maskRequestHeaders = Collections.emptyList();
    private static boolean captureRequestRemoteAddr;
    private static boolean captureRequestRemoteHost;
    private static List<Pattern> captureResponseHeaders;
    private static boolean traceErrorOn4xxResponseCode;

    private JavaHttpServerPluginProperties() {
    }

    static List<Pattern> captureRequestHeaders() {
        return captureRequestHeaders;
    }

    static List<Pattern> maskRequestHeaders() {
        return maskRequestHeaders;
    }

    static boolean captureRequestRemoteAddr() {
        return captureRequestRemoteAddr;
    }

    static boolean captureRequestRemoteHost() {
        return captureRequestRemoteHost;
    }

    static List<Pattern> captureResponseHeaders() {
        return captureResponseHeaders;
    }

    static boolean traceErrorOn4xxResponseCode() {
        return traceErrorOn4xxResponseCode;
    }

    static {
        captureResponseHeaders = Collections.emptyList();
        configService.registerConfigListener(new JavaHttpServerPluginConfigListener());
    }

    private static class JavaHttpServerPluginConfigListener
    implements ConfigListener {
        private JavaHttpServerPluginConfigListener() {
        }

        @Override
        public void onChange() {
            JavaHttpServerPluginConfigListener.recalculateProperties();
        }

        private static void recalculateProperties() {
            captureRequestHeaders = JavaHttpServerPluginConfigListener.buildPatternList(JavaHttpServerPluginProperties.CAPTURE_REQUEST_HEADER_PROPERTY_NAME);
            maskRequestHeaders = JavaHttpServerPluginConfigListener.buildPatternList(JavaHttpServerPluginProperties.MASK_REQUEST_HEADER_PROPERTY_NAME);
            captureRequestRemoteAddr = configService.getBooleanProperty(JavaHttpServerPluginProperties.CAPTURE_REQUEST_REMOTE_ADDR_PROPERTY_NAME).value();
            captureRequestRemoteHost = configService.getBooleanProperty(JavaHttpServerPluginProperties.CAPTURE_REQUEST_REMOTE_HOST_PROPERTY_NAME).value();
            captureResponseHeaders = JavaHttpServerPluginConfigListener.buildPatternList(JavaHttpServerPluginProperties.CAPTURE_RESPONSE_HEADER_PROPERTY_NAME);
            traceErrorOn4xxResponseCode = configService.getBooleanProperty(JavaHttpServerPluginProperties.TRACE_ERROR_ON_4XX_RESPONSE_CODE).value();
        }

        private static List<Pattern> buildPatternList(String propertyName) {
            List<String> items = configService.getListProperty(propertyName).value();
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String parameter : items) {
                patterns.add(JavaHttpServerPluginConfigListener.buildRegexPattern(parameter.trim().toLowerCase(Locale.ENGLISH)));
            }
            return ImmutableList.copyOf(patterns);
        }

        private static Pattern buildRegexPattern(String wildcardPattern) {
            String regex = "\\Q" + wildcardPattern.replace("*", "\\E.*\\Q") + "\\E";
            regex = regex.replace("\\Q\\E", "");
            return Pattern.compile(regex);
        }
    }
}

