/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.jdbc;

import java.util.concurrent.TimeUnit;
import org.glowroot.agent.plugin.api.Agent;
import org.glowroot.agent.plugin.api.Logger;
import org.glowroot.agent.plugin.api.Message;
import org.glowroot.agent.plugin.api.MessageSupplier;
import org.glowroot.agent.plugin.api.ThreadContext;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.TraceEntry;
import org.glowroot.agent.plugin.api.checker.MonotonicNonNull;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.config.BooleanProperty;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindThrowable;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.IsEnabled;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.OnThrow;
import org.glowroot.agent.plugin.api.weaving.Pointcut;
import org.glowroot.agent.plugin.api.weaving.Shim;
import org.glowroot.agent.plugin.jdbc.JdbcPluginProperties;

public class DataSourceAspect {
    private static final Logger logger = Logger.getLogger(DataSourceAspect.class);
    private static final ConfigService configService = Agent.getConfigService("jdbc");
    private static final BooleanProperty captureGetConnection = configService.getBooleanProperty("captureGetConnection");
    private static final BooleanProperty captureConnectionLifecycleTraceEntries = configService.getBooleanProperty("captureConnectionLifecycleTraceEntries");
    private static final BooleanProperty captureTransactionLifecycleTraceEntries = configService.getBooleanProperty("captureTransactionLifecycleTraceEntries");

    private static class GetConnectionMessageSupplier
    extends MessageSupplier {
        @MonotonicNonNull
        private volatile String autoCommit;

        private GetConnectionMessageSupplier() {
        }

        @Override
        public Message get() {
            if (this.autoCommit == null) {
                return Message.create("jdbc get connection");
            }
            return Message.create("jdbc get connection (autocommit: {})", this.autoCommit);
        }

        private void setAutoCommit(String autoCommit) {
            this.autoCommit = autoCommit;
        }
    }

    @Pointcut(className="javax.sql.DataSource", methodName="getConnection", methodParameterTypes={".."}, nestingGroup="jdbc", timerName="jdbc get connection")
    public static class GetConnectionAdvice {
        private static final TimerName timerName = Agent.getTimerName(GetConnectionAdvice.class);

        @IsEnabled
        public static boolean isEnabled() {
            return captureGetConnection.value() || captureConnectionLifecycleTraceEntries.value();
        }

        @OnBefore
        public static Object onBefore(ThreadContext context) {
            if (captureConnectionLifecycleTraceEntries.value()) {
                return context.startTraceEntry(new GetConnectionMessageSupplier(), timerName);
            }
            return context.startTimer(timerName);
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable Connection connection, @BindTraveler Object entryOrTimer) {
            if (entryOrTimer instanceof TraceEntry) {
                GetConnectionAdvice.onReturnTraceEntry(connection, (TraceEntry)entryOrTimer);
            } else {
                ((Timer)entryOrTimer).stop();
            }
        }

        @OnThrow
        public static void onThrow(@BindThrowable Throwable t, @BindTraveler Object entryOrTimer) {
            if (entryOrTimer instanceof TraceEntry) {
                ((TraceEntry)entryOrTimer).endWithError(t);
            } else {
                ((Timer)entryOrTimer).stop();
            }
        }

        private static void onReturnTraceEntry(@Nullable Connection connection, TraceEntry traceEntry) {
            GetConnectionMessageSupplier messageSupplier;
            if (captureTransactionLifecycleTraceEntries.value() && connection != null && (messageSupplier = (GetConnectionMessageSupplier)traceEntry.getMessageSupplier()) != null) {
                String autoCommit;
                try {
                    autoCommit = Boolean.toString(connection.getAutoCommit());
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), e);
                    autoCommit = "<error occurred: " + e.toString() + ">";
                }
                messageSupplier.setAutoCommit(autoCommit);
            }
            traceEntry.endWithLocationStackTrace(JdbcPluginProperties.stackTraceThresholdMillis(), TimeUnit.MILLISECONDS);
        }
    }

    @Shim(value={"java.sql.Connection"})
    public static interface Connection {
        public boolean getAutoCommit();
    }
}

