/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.servlet._;

import java.lang.reflect.Method;
import org.glowroot.agent.plugin.api.ClassInfo;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.util.Reflection;

public class RequestInvoker {
    @Nullable
    private final Method getRemotePortMethod;
    @Nullable
    private final Method getLocalAddrMethod;
    @Nullable
    private final Method getLocalNameMethod;
    @Nullable
    private final Method getLocalPortMethod;

    public RequestInvoker(ClassInfo classInfo) {
        Class<?> servletRequestClass = Reflection.getClassWithWarnIfNotFound("javax.servlet.ServletRequest", classInfo.getLoader());
        this.getRemotePortMethod = Reflection.getMethod(servletRequestClass, "getRemotePort", new Class[0]);
        this.getLocalAddrMethod = Reflection.getMethod(servletRequestClass, "getLocalAddr", new Class[0]);
        this.getLocalNameMethod = Reflection.getMethod(servletRequestClass, "getLocalName", new Class[0]);
        this.getLocalPortMethod = Reflection.getMethod(servletRequestClass, "getLocalPort", new Class[0]);
    }

    public int getRemotePort(Object request) {
        return Reflection.invokeWithDefault(this.getRemotePortMethod, request, -1, new Object[0]);
    }

    public String getLocalAddr(Object request) {
        return Reflection.invokeWithDefault(this.getLocalAddrMethod, request, "", new Object[0]);
    }

    public String getLocalName(Object request) {
        return Reflection.invokeWithDefault(this.getLocalNameMethod, request, "", new Object[0]);
    }

    public int getLocalPort(Object request) {
        return Reflection.invokeWithDefault(this.getLocalPortMethod, request, -1, new Object[0]);
    }
}

