/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.spring;

import org.glowroot.agent.plugin.api.MethodInfo;

public class ControllerMethodMeta {
    private final String controllerClassName;
    private final String methodName;
    private final String altTransactionName;

    public ControllerMethodMeta(MethodInfo methodInfo) {
        this.controllerClassName = methodInfo.getDeclaringClassName();
        this.methodName = methodInfo.getName();
        this.altTransactionName = ControllerMethodMeta.getSimpleName(this.controllerClassName) + "#" + this.methodName;
    }

    String getControllerClassName() {
        return this.controllerClassName;
    }

    String getMethodName() {
        return this.methodName;
    }

    String getAltTransactionName() {
        return this.altTransactionName;
    }

    private static String getSimpleName(String className) {
        return ControllerMethodMeta.substringAfterLast(ControllerMethodMeta.substringAfterLast(className, '.'), '$');
    }

    private static String substringAfterLast(String str, char c) {
        int index = str.lastIndexOf(c);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }
}

