/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.ch.qos.logback.core.status;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glowroot.agent.shaded.ch.qos.logback.core.Context;
import org.glowroot.agent.shaded.ch.qos.logback.core.status.ErrorStatus;
import org.glowroot.agent.shaded.ch.qos.logback.core.status.Status;
import org.glowroot.agent.shaded.ch.qos.logback.core.status.StatusListener;
import org.glowroot.agent.shaded.ch.qos.logback.core.status.StatusManager;

public class StatusUtil {
    StatusManager sm;

    public StatusUtil(Context context) {
        this.sm = context.getStatusManager();
    }

    public static boolean contextHasStatusListener(Context context) {
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            return false;
        }
        List<StatusListener> listeners = sm.getCopyOfStatusListenerList();
        return listeners != null && listeners.size() != 0;
    }

    public static List<Status> filterStatusListByTimeThreshold(List<Status> rawList, long threshold) {
        ArrayList<Status> filteredList = new ArrayList<Status>();
        for (Status s : rawList) {
            if (s.getDate() < threshold) continue;
            filteredList.add(s);
        }
        return filteredList;
    }

    public void addStatus(Status status) {
        if (this.sm != null) {
            this.sm.add(status);
        }
    }

    public void addError(Object caller, String msg, Throwable t) {
        this.addStatus(new ErrorStatus(msg, caller, t));
    }

    public boolean hasXMLParsingErrors(long threshold) {
        return this.containsMatch(threshold, 2, "XML_PARSING");
    }

    public boolean noXMLParsingErrorsOccurred(long threshold) {
        return !this.hasXMLParsingErrors(threshold);
    }

    public int getHighestLevel(long threshold) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        int maxLevel = 0;
        for (Status s : filteredList) {
            if (s.getLevel() <= maxLevel) continue;
            maxLevel = s.getLevel();
        }
        return maxLevel;
    }

    public boolean containsMatch(long threshold, int level, String regex) {
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(this.sm.getCopyOfStatusList(), threshold);
        Pattern p = Pattern.compile(regex);
        for (Status status : filteredList) {
            String msg;
            Matcher matcher;
            if (level != status.getLevel() || !(matcher = p.matcher(msg = status.getMessage())).lookingAt()) continue;
            return true;
        }
        return false;
    }
}

