/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Locale;
import java.util.TimeZone;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface JsonFormat {
    public String pattern() default "";

    public Shape shape() default Shape.ANY;

    public String locale() default "##default";

    public String timezone() default "##default";

    public Feature[] with() default {};

    public Feature[] without() default {};

    public static class Value {
        private final String pattern;
        private final Shape shape;
        private final Locale locale;
        private final String timezoneStr;
        private final Features features;
        private TimeZone _timezone;

        public Value() {
            this("", Shape.ANY, "", "", Features.empty());
        }

        public Value(JsonFormat ann) {
            this(ann.pattern(), ann.shape(), ann.locale(), ann.timezone(), Features.construct(ann));
        }

        public Value(String p, Shape sh, String localeStr, String tzStr, Features f) {
            this(p, sh, localeStr == null || localeStr.length() == 0 || "##default".equals(localeStr) ? null : new Locale(localeStr), tzStr == null || tzStr.length() == 0 || "##default".equals(tzStr) ? null : tzStr, null, f);
        }

        public Value(String p, Shape sh, Locale l, String tzStr, TimeZone tz, Features f) {
            this.pattern = p;
            this.shape = sh == null ? Shape.ANY : sh;
            this.locale = l;
            this._timezone = tz;
            this.timezoneStr = tzStr;
            this.features = f == null ? Features.empty() : f;
        }

        public String getPattern() {
            return this.pattern;
        }

        public Shape getShape() {
            return this.shape;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimeZone getTimeZone() {
            TimeZone tz = this._timezone;
            if (tz == null) {
                if (this.timezoneStr == null) {
                    return null;
                }
                this._timezone = tz = TimeZone.getTimeZone(this.timezoneStr);
            }
            return tz;
        }

        public boolean hasPattern() {
            return this.pattern != null && this.pattern.length() > 0;
        }

        public boolean hasLocale() {
            return this.locale != null;
        }

        public Boolean getFeature(Feature f) {
            return this.features.get(f);
        }
    }

    public static class Features {
        private final int enabled;
        private final int disabled;
        private static final Features EMPTY = new Features(0, 0);

        private Features(int e, int d) {
            this.enabled = e;
            this.disabled = d;
        }

        public static Features empty() {
            return EMPTY;
        }

        public static Features construct(JsonFormat f) {
            return Features.construct(f.with(), f.without());
        }

        public static Features construct(Feature[] enabled, Feature[] disabled) {
            int e = 0;
            for (Feature f : enabled) {
                e |= 1 << f.ordinal();
            }
            int d = 0;
            for (Feature f : disabled) {
                d |= 1 << f.ordinal();
            }
            return new Features(e, d);
        }

        public Boolean get(Feature f) {
            int mask = 1 << f.ordinal();
            if ((this.disabled & mask) != 0) {
                return Boolean.FALSE;
            }
            if ((this.enabled & mask) != 0) {
                return Boolean.TRUE;
            }
            return null;
        }
    }

    public static enum Feature {
        ACCEPT_SINGLE_VALUE_AS_ARRAY,
        WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS,
        WRITE_DATES_WITH_ZONE_ID,
        WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED,
        WRITE_SORTED_MAP_ENTRIES;

    }

    public static enum Shape {
        ANY,
        SCALAR,
        ARRAY,
        OBJECT,
        NUMBER,
        NUMBER_FLOAT,
        NUMBER_INT,
        STRING,
        BOOLEAN;


        public boolean isNumeric() {
            return this == NUMBER || this == NUMBER_INT || this == NUMBER_FLOAT;
        }
    }
}

