/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.databind;

import java.io.Serializable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.core.util.Instantiatable;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.MapperFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg.BaseSettings;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.RootNameLookup;

public final class SerializationConfig
extends MapperConfigBase<SerializationFeature, SerializationConfig>
implements Serializable {
    protected static final PrettyPrinter DEFAULT_PRETTY_PRINTER = new DefaultPrettyPrinter();
    protected final int _serFeatures;
    protected JsonInclude.Include _serializationInclusion = null;
    protected final FilterProvider _filterProvider;
    protected final PrettyPrinter _defaultPrettyPrinter;
    protected final int _generatorFeatures;
    protected final int _generatorFeaturesToChange;

    public SerializationConfig(BaseSettings base, SubtypeResolver str, SimpleMixInResolver mixins, RootNameLookup rootNames) {
        super(base, str, mixins, rootNames);
        this._serFeatures = SerializationConfig.collectFeatureDefaults(SerializationFeature.class);
        this._filterProvider = null;
        this._defaultPrettyPrinter = DEFAULT_PRETTY_PRINTER;
        this._generatorFeatures = 0;
        this._generatorFeaturesToChange = 0;
    }

    private SerializationConfig(SerializationConfig src, int mapperFeatures, int serFeatures, int generatorFeatures, int generatorFeatureMask) {
        super(src, mapperFeatures);
        this._serFeatures = serFeatures;
        this._serializationInclusion = src._serializationInclusion;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._generatorFeatures = generatorFeatures;
        this._generatorFeaturesToChange = generatorFeatureMask;
    }

    private SerializationConfig(SerializationConfig src, BaseSettings base) {
        super(src, base);
        this._serFeatures = src._serFeatures;
        this._serializationInclusion = src._serializationInclusion;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._generatorFeatures = src._generatorFeatures;
        this._generatorFeaturesToChange = src._generatorFeaturesToChange;
    }

    private SerializationConfig(SerializationConfig src, JsonInclude.Include incl) {
        super(src);
        this._serFeatures = src._serFeatures;
        this._serializationInclusion = incl;
        this._filterProvider = src._filterProvider;
        this._defaultPrettyPrinter = src._defaultPrettyPrinter;
        this._generatorFeatures = src._generatorFeatures;
        this._generatorFeaturesToChange = src._generatorFeaturesToChange;
    }

    public SerializationConfig with(MapperFeature ... features) {
        int newMapperFlags = this._mapperFeatures;
        for (MapperFeature f : features) {
            newMapperFlags |= f.getMask();
        }
        return newMapperFlags == this._mapperFeatures ? this : new SerializationConfig(this, newMapperFlags, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange);
    }

    public SerializationConfig without(MapperFeature ... features) {
        int newMapperFlags = this._mapperFeatures;
        for (MapperFeature f : features) {
            newMapperFlags &= ~f.getMask();
        }
        return newMapperFlags == this._mapperFeatures ? this : new SerializationConfig(this, newMapperFlags, this._serFeatures, this._generatorFeatures, this._generatorFeaturesToChange);
    }

    public SerializationConfig with(PropertyNamingStrategy pns) {
        return this._withBase(this._base.withPropertyNamingStrategy(pns));
    }

    public SerializationConfig with(TypeFactory tf) {
        return this._withBase(this._base.withTypeFactory(tf));
    }

    private final SerializationConfig _withBase(BaseSettings newBase) {
        return this._base == newBase ? this : new SerializationConfig(this, newBase);
    }

    public SerializationConfig without(SerializationFeature feature) {
        int newSerFeatures = this._serFeatures & ~feature.getMask();
        return newSerFeatures == this._serFeatures ? this : new SerializationConfig(this, this._mapperFeatures, newSerFeatures, this._generatorFeatures, this._generatorFeaturesToChange);
    }

    public SerializationConfig withSerializationInclusion(JsonInclude.Include incl) {
        return this._serializationInclusion == incl ? this : new SerializationConfig(this, incl);
    }

    public PrettyPrinter constructDefaultPrettyPrinter() {
        PrettyPrinter pp = this._defaultPrettyPrinter;
        if (pp instanceof Instantiatable) {
            pp = (PrettyPrinter)((Instantiatable)((Object)pp)).createInstance();
        }
        return pp;
    }

    public void initialize(JsonGenerator g) {
        PrettyPrinter pp;
        if (SerializationFeature.INDENT_OUTPUT.enabledIn(this._serFeatures) && g.getPrettyPrinter() == null && (pp = this.constructDefaultPrettyPrinter()) != null) {
            g.setPrettyPrinter(pp);
        }
        boolean useBigDec = SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN.enabledIn(this._serFeatures);
        if (this._generatorFeaturesToChange != 0 || useBigDec) {
            int orig = g.getFeatureMask();
            int newFlags = orig & ~this._generatorFeaturesToChange | this._generatorFeatures;
            if (useBigDec) {
                newFlags |= JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN.getMask();
            }
            if (orig != newFlags) {
                g.setFeatureMask(newFlags);
            }
        }
    }

    @Override
    public AnnotationIntrospector getAnnotationIntrospector() {
        if (this.isEnabled(MapperFeature.USE_ANNOTATIONS)) {
            return super.getAnnotationIntrospector();
        }
        return AnnotationIntrospector.nopInstance();
    }

    @Override
    public BeanDescription introspectClassAnnotations(JavaType type) {
        return this.getClassIntrospector().forClassAnnotations(this, type, this);
    }

    @Override
    public VisibilityChecker<?> getDefaultVisibilityChecker() {
        VisibilityChecker<?> vchecker = super.getDefaultVisibilityChecker();
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_GETTERS)) {
            vchecker = vchecker.withGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_IS_GETTERS)) {
            vchecker = vchecker.withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
        }
        if (!this.isEnabled(MapperFeature.AUTO_DETECT_FIELDS)) {
            vchecker = vchecker.withFieldVisibility(JsonAutoDetect.Visibility.NONE);
        }
        return vchecker;
    }

    public final boolean isEnabled(SerializationFeature f) {
        return (this._serFeatures & f.getMask()) != 0;
    }

    public JsonInclude.Include getSerializationInclusion() {
        if (this._serializationInclusion != null) {
            return this._serializationInclusion;
        }
        return JsonInclude.Include.ALWAYS;
    }

    public FilterProvider getFilterProvider() {
        return this._filterProvider;
    }

    public <T extends BeanDescription> T introspect(JavaType type) {
        return (T)this.getClassIntrospector().forSerialization(this, type, this);
    }

    public String toString() {
        return "[SerializationConfig: flags=0x" + Integer.toHexString(this._serFeatures) + "]";
    }
}

