/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava;

import java.util.HashSet;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JavaType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.Serializers;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.MapLikeType;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.ArrayBuilders;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.util.StdConverter;
import org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.ser.GuavaOptionalSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.ser.MultimapSerializer;
import org.glowroot.agent.shaded.com.fasterxml.jackson.datatype.guava.ser.RangeSerializer;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilderSpec;
import org.glowroot.agent.shaded.com.google.common.collect.FluentIterable;
import org.glowroot.agent.shaded.com.google.common.collect.Multimap;
import org.glowroot.agent.shaded.com.google.common.collect.Range;
import org.glowroot.agent.shaded.com.google.common.hash.HashCode;
import org.glowroot.agent.shaded.com.google.common.net.HostAndPort;
import org.glowroot.agent.shaded.com.google.common.net.InternetDomainName;

public class GuavaSerializers
extends Serializers.Base {
    @Override
    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> raw = type.getRawClass();
        if (Optional.class.isAssignableFrom(raw)) {
            return new GuavaOptionalSerializer(type);
        }
        if (Range.class.isAssignableFrom(raw)) {
            return new RangeSerializer(type);
        }
        if (HostAndPort.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (InternetDomainName.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (CacheBuilderSpec.class.isAssignableFrom(raw) || CacheBuilder.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (HashCode.class.isAssignableFrom(raw)) {
            return ToStringSerializer.instance;
        }
        if (FluentIterable.class.isAssignableFrom(raw)) {
            JavaType vt = type.containedType(0);
            if (vt == null) {
                vt = TypeFactory.unknownType();
            }
            JavaType delegate = config.getTypeFactory().constructParametrizedType(Iterable.class, Iterable.class, vt);
            return new StdDelegatingSerializer(FluentConverter.instance, delegate, null);
        }
        return super.findSerializer(config, type, beanDesc);
    }

    @Override
    public JsonSerializer<?> findMapLikeSerializer(SerializationConfig config, MapLikeType type, BeanDescription beanDesc, JsonSerializer<Object> keySerializer, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (Multimap.class.isAssignableFrom(type.getRawClass())) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            Object filterId = intr.findFilterId(beanDesc.getClassInfo());
            String[] ignored = intr.findPropertiesToIgnore(beanDesc.getClassInfo(), true);
            HashSet<String> ignoredEntries = ignored == null || ignored.length == 0 ? null : ArrayBuilders.arrayToSet(ignored);
            return new MultimapSerializer(type, beanDesc, keySerializer, elementTypeSerializer, elementValueSerializer, ignoredEntries, filterId);
        }
        return null;
    }

    static class FluentConverter
    extends StdConverter<Object, Iterable<?>> {
        static final FluentConverter instance = new FluentConverter();

        FluentConverter() {
        }

        @Override
        public Iterable<?> convert(Object value) {
            return (Iterable)value;
        }
    }
}

