/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.com.jcraft.jzlib;

import org.glowroot.agent.shaded.com.jcraft.jzlib.Checksum;

public final class CRC32
implements Checksum {
    private int v = 0;
    private static int[] crc_table = null;

    public void update(byte[] buf, int index, int len) {
        int c = ~this.v;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[index++]) & 0xFF] ^ c >>> 8;
        }
        this.v = ~c;
    }

    public void reset() {
        this.v = 0;
    }

    public long getValue() {
        return (long)this.v & 0xFFFFFFFFL;
    }

    static {
        crc_table = new int[256];
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            CRC32.crc_table[n] = c;
        }
    }
}

