/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.AbstractStream;
import org.glowroot.agent.shaded.io.grpc.internal.MessageFramer;
import org.glowroot.agent.shaded.io.grpc.internal.ServerStream;
import org.glowroot.agent.shaded.io.grpc.internal.ServerStreamListener;
import org.glowroot.agent.shaded.io.grpc.internal.StatsTraceContext;
import org.glowroot.agent.shaded.io.grpc.internal.WritableBuffer;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

public abstract class AbstractServerStream
extends AbstractStream
implements MessageFramer.Sink,
ServerStream {
    private final MessageFramer framer;

    @Override
    protected abstract TransportState transportState();

    protected abstract Sink abstractServerStreamSink();

    @Override
    protected final MessageFramer framer() {
        return this.framer;
    }

    @Override
    public final void request(int numMessages) {
        this.abstractServerStreamSink().request(numMessages);
    }

    @Override
    public final void deliverFrame(WritableBuffer frame, boolean endOfStream, boolean flush, int numMessages) {
        this.abstractServerStreamSink().writeFrame(frame, endOfStream ? false : flush, numMessages);
    }

    protected static abstract class TransportState
    extends AbstractStream.TransportState {
        private boolean listenerClosed;
        private ServerStreamListener listener;
        private final StatsTraceContext statsTraceCtx;
        private boolean endOfStream;
        private boolean deframerClosed;
        private boolean immediateCloseRequested;
        private Runnable deframerClosedTask;
        @Nullable
        private Status closedStatus;

        @Override
        public final void onStreamAllocated() {
            super.onStreamAllocated();
            this.getTransportTracer().reportRemoteStreamStarted();
        }

        @Override
        public void deframerClosed(boolean hasPartialMessage) {
            this.deframerClosed = true;
            if (this.endOfStream) {
                if (!this.immediateCloseRequested && hasPartialMessage) {
                    this.deframeFailed(Status.INTERNAL.withDescription("Encountered end-of-stream mid-frame").asRuntimeException());
                    this.deframerClosedTask = null;
                    return;
                }
                this.listener.halfClosed();
            }
            if (this.deframerClosedTask != null) {
                this.deframerClosedTask.run();
                this.deframerClosedTask = null;
            }
        }

        @Override
        protected ServerStreamListener listener() {
            return this.listener;
        }

        public final void transportReportStatus(final Status status) {
            Preconditions.checkArgument(!status.isOk(), "status must not be OK");
            if (this.deframerClosed) {
                this.deframerClosedTask = null;
                this.closeListener(status);
            } else {
                this.deframerClosedTask = new Runnable(){

                    @Override
                    public void run() {
                        TransportState.this.closeListener(status);
                    }
                };
                this.immediateCloseRequested = true;
                this.closeDeframer(true);
            }
        }

        public void complete() {
            if (this.deframerClosed) {
                this.deframerClosedTask = null;
                this.closeListener(Status.OK);
            } else {
                this.deframerClosedTask = new Runnable(){

                    @Override
                    public void run() {
                        TransportState.this.closeListener(Status.OK);
                    }
                };
                this.immediateCloseRequested = true;
                this.closeDeframer(true);
            }
        }

        private void closeListener(Status newStatus) {
            Preconditions.checkState(!newStatus.isOk() || this.closedStatus != null);
            if (!this.listenerClosed) {
                if (!newStatus.isOk()) {
                    this.statsTraceCtx.streamClosed(newStatus);
                    this.getTransportTracer().reportStreamClosed(false);
                } else {
                    this.statsTraceCtx.streamClosed(this.closedStatus);
                    this.getTransportTracer().reportStreamClosed(this.closedStatus.isOk());
                }
                this.listenerClosed = true;
                this.onStreamDeallocated();
                this.listener().closed(newStatus);
            }
        }
    }

    protected static interface Sink {
        public void writeFrame(@Nullable WritableBuffer var1, boolean var2, int var3);

        public void request(int var1);
    }
}

