/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.ConnectivityState;
import org.glowroot.agent.shaded.io.grpc.ConnectivityStateInfo;
import org.glowroot.agent.shaded.io.grpc.EquivalentAddressGroup;
import org.glowroot.agent.shaded.io.grpc.LoadBalancer;
import org.glowroot.agent.shaded.io.grpc.PickFirstBalancerFactory;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcAttributes;
import org.glowroot.agent.shaded.io.grpc.internal.ServiceConfigUtil;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

final class AutoConfiguredLoadBalancerFactory
extends LoadBalancer.Factory {
    AutoConfiguredLoadBalancerFactory() {
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new AutoConfiguredLoadBalancer(helper);
    }

    private static final class FailingPicker
    extends LoadBalancer.SubchannelPicker {
        private final Status failure;

        FailingPicker(Status failure) {
            this.failure = failure;
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withError(this.failure);
        }
    }

    private static final class EmptyPicker
    extends LoadBalancer.SubchannelPicker {
        private EmptyPicker() {
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    static final class AutoConfiguredLoadBalancer
    extends LoadBalancer {
        private final LoadBalancer.Helper helper;
        private LoadBalancer delegate;
        private LoadBalancer.Factory delegateFactory;

        AutoConfiguredLoadBalancer(LoadBalancer.Helper helper) {
            this.helper = helper;
            this.delegateFactory = PickFirstBalancerFactory.getInstance();
            this.delegate = this.delegateFactory.newLoadBalancer(helper);
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> servers, Attributes attributes) {
            LoadBalancer.Factory newlbf;
            Map<String, Object> configMap = attributes.get(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG);
            try {
                newlbf = AutoConfiguredLoadBalancer.decideLoadBalancerFactory(servers, configMap);
            }
            catch (RuntimeException e) {
                Status s = Status.INTERNAL.withDescription("Failed to pick a load balancer from service config").withCause(e);
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new FailingPicker(s));
                this.delegate.shutdown();
                this.delegateFactory = null;
                this.delegate = new NoopLoadBalancer();
                return;
            }
            if (newlbf != null && newlbf != this.delegateFactory) {
                this.helper.updateBalancingState(ConnectivityState.CONNECTING, new EmptyPicker());
                this.delegate.shutdown();
                this.delegateFactory = newlbf;
                this.delegate = this.delegateFactory.newLoadBalancer(this.helper);
            }
            this.getDelegate().handleResolvedAddressGroups(servers, attributes);
        }

        @Override
        public void handleNameResolutionError(Status error) {
            this.getDelegate().handleNameResolutionError(error);
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
            this.getDelegate().handleSubchannelState(subchannel, stateInfo);
        }

        @Override
        public void shutdown() {
            this.delegate.shutdown();
            this.delegate = null;
        }

        LoadBalancer getDelegate() {
            return this.delegate;
        }

        @Nullable
        static LoadBalancer.Factory decideLoadBalancerFactory(List<EquivalentAddressGroup> servers, @Nullable Map<String, Object> config) {
            boolean haveBalancerAddress = false;
            for (EquivalentAddressGroup s : servers) {
                if (s.getAttributes().get(GrpcAttributes.ATTR_LB_ADDR_AUTHORITY) == null) continue;
                haveBalancerAddress = true;
                break;
            }
            if (haveBalancerAddress) {
                try {
                    Class<?> lbFactoryClass = Class.forName("org.glowroot.agent.shaded.io.grpc.grpclb.GrpclbLoadBalancerFactory");
                    Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                    return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't get GRPCLB, but balancer addresses were present", e);
                }
            }
            String serviceConfigChoiceBalancingPolicy = null;
            if (config != null) {
                serviceConfigChoiceBalancingPolicy = ServiceConfigUtil.getLoadBalancingPolicyFromServiceConfig(config);
            }
            if (serviceConfigChoiceBalancingPolicy != null) {
                if (serviceConfigChoiceBalancingPolicy.toUpperCase(Locale.ROOT).equals("ROUND_ROBIN")) {
                    try {
                        Class<?> lbFactoryClass = Class.forName("org.glowroot.agent.shaded.io.grpc.util.RoundRobinLoadBalancerFactory");
                        Method getInstance = lbFactoryClass.getMethod("getInstance", new Class[0]);
                        return (LoadBalancer.Factory)getInstance.invoke(null, new Object[0]);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Can't get Round Robin LB", e);
                    }
                }
                throw new IllegalArgumentException("Unknown service config policy: " + serviceConfigChoiceBalancingPolicy);
            }
            return PickFirstBalancerFactory.getInstance();
        }
    }

    private static final class NoopLoadBalancer
    extends LoadBalancer {
        private NoopLoadBalancer() {
        }

        @Override
        public void handleResolvedAddressGroups(List<EquivalentAddressGroup> s, Attributes a) {
        }

        @Override
        public void handleNameResolutionError(Status error) {
        }

        @Override
        public void handleSubchannelState(LoadBalancer.Subchannel subchannel, ConnectivityStateInfo stateInfo) {
        }

        @Override
        public void shutdown() {
        }
    }
}

