/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import java.net.URI;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.NameResolverProvider;
import org.glowroot.agent.shaded.io.grpc.internal.DnsNameResolver;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    @Override
    public DnsNameResolver newNameResolver(URI targetUri, Attributes params) {
        if ("dns".equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, params, GrpcUtil.SHARED_CHANNEL_EXECUTOR, GrpcUtil.getDefaultProxyDetector());
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return "dns";
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 5;
    }
}

