/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.internal;

import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.CallCredentials;
import org.glowroot.agent.shaded.io.grpc.CallOptions;
import org.glowroot.agent.shaded.io.grpc.Context;
import org.glowroot.agent.shaded.io.grpc.Metadata;
import org.glowroot.agent.shaded.io.grpc.MethodDescriptor;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.ClientStream;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransport;
import org.glowroot.agent.shaded.io.grpc.internal.DelayedStream;
import org.glowroot.agent.shaded.io.grpc.internal.FailingClientStream;
import org.glowroot.agent.shaded.javax.annotation.Nullable;
import org.glowroot.agent.shaded.javax.annotation.concurrent.GuardedBy;

final class MetadataApplierImpl
implements CallCredentials.MetadataApplier {
    private final ClientTransport transport;
    private final MethodDescriptor<?, ?> method;
    private final Metadata origHeaders;
    private final CallOptions callOptions;
    private final Context ctx;
    private final Object lock = new Object();
    @Nullable
    @GuardedBy(value="lock")
    private ClientStream returnedStream;
    boolean finalized;
    DelayedStream delayedStream;

    MetadataApplierImpl(ClientTransport transport, MethodDescriptor<?, ?> method, Metadata origHeaders, CallOptions callOptions) {
        this.transport = transport;
        this.method = method;
        this.origHeaders = origHeaders;
        this.callOptions = callOptions;
        this.ctx = Context.current();
    }

    public void fail(Status status) {
        Preconditions.checkArgument(!status.isOk(), "Cannot fail with OK status");
        Preconditions.checkState(!this.finalized, "apply() or fail() already called");
        this.finalizeWith(new FailingClientStream(status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeWith(ClientStream stream) {
        Preconditions.checkState(!this.finalized, "already finalized");
        this.finalized = true;
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.returnedStream = stream;
                return;
            }
        }
        Preconditions.checkState(this.delayedStream != null, "delayedStream is null");
        this.delayedStream.setStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientStream returnStream() {
        Object object = this.lock;
        synchronized (object) {
            if (this.returnedStream == null) {
                this.delayedStream = new DelayedStream();
                this.returnedStream = this.delayedStream;
                return this.returnedStream;
            }
            return this.returnedStream;
        }
    }
}

