/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.io.grpc.Attributes;
import org.glowroot.agent.shaded.io.grpc.NameResolver;
import org.glowroot.agent.shaded.io.grpc.internal.AbstractManagedChannelImplBuilder;
import org.glowroot.agent.shaded.io.grpc.internal.AtomicBackoff;
import org.glowroot.agent.shaded.io.grpc.internal.ClientTransportFactory;
import org.glowroot.agent.shaded.io.grpc.internal.ConnectionClientTransport;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;
import org.glowroot.agent.shaded.io.grpc.internal.KeepAliveManager;
import org.glowroot.agent.shaded.io.grpc.internal.ProxyParameters;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourceHolder;
import org.glowroot.agent.shaded.io.grpc.internal.TransportTracer;
import org.glowroot.agent.shaded.io.grpc.netty.GrpcSslContexts;
import org.glowroot.agent.shaded.io.grpc.netty.NegotiationType;
import org.glowroot.agent.shaded.io.grpc.netty.NettyClientTransport;
import org.glowroot.agent.shaded.io.grpc.netty.ProtocolNegotiator;
import org.glowroot.agent.shaded.io.grpc.netty.ProtocolNegotiators;
import org.glowroot.agent.shaded.io.grpc.netty.Utils;
import org.glowroot.agent.shaded.io.netty.channel.Channel;
import org.glowroot.agent.shaded.io.netty.channel.ChannelOption;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.glowroot.agent.shaded.io.netty.handler.ssl.SslContext;
import org.glowroot.agent.shaded.javax.annotation.CheckReturnValue;
import org.glowroot.agent.shaded.javax.annotation.Nullable;

@CanIgnoreReturnValue
public final class NettyChannelBuilder
extends AbstractManagedChannelImplBuilder<NettyChannelBuilder> {
    private static final long AS_LARGE_AS_INFINITE = TimeUnit.DAYS.toNanos(1000L);
    private final Map<ChannelOption<?>, Object> channelOptions = new HashMap();
    private NegotiationType negotiationType = NegotiationType.TLS;
    private OverrideAuthorityChecker authorityChecker;
    private Class<? extends Channel> channelType = NioSocketChannel.class;
    @Nullable
    private EventLoopGroup eventLoopGroup;
    private SslContext sslContext;
    private int flowControlWindow = 0x100000;
    private int maxHeaderListSize = 8192;
    private long keepAliveTimeNanos = Long.MAX_VALUE;
    private long keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
    private boolean keepAliveWithoutCalls;
    private TransportCreationParamsFilterFactory dynamicParamsFactory;

    @CheckReturnValue
    public static NettyChannelBuilder forAddress(String host, int port) {
        return new NettyChannelBuilder(host, port);
    }

    @CheckReturnValue
    public static NettyChannelBuilder forTarget(String target) {
        return new NettyChannelBuilder(target);
    }

    @CheckReturnValue
    NettyChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort(host, port));
    }

    @CheckReturnValue
    NettyChannelBuilder(String target) {
        super(target);
    }

    public NettyChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = type;
        return this;
    }

    public NettyChannelBuilder eventLoopGroup(@Nullable EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public NettyChannelBuilder sslContext(SslContext sslContext) {
        if (sslContext != null) {
            Preconditions.checkArgument(sslContext.isClient(), "Server SSL context can not be used for client channel");
            GrpcSslContexts.ensureAlpnAndH2Enabled(sslContext.applicationProtocolNegotiator());
        }
        this.sslContext = sslContext;
        return this;
    }

    public NettyChannelBuilder keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        Preconditions.checkArgument(keepAliveTime > 0L, "keepalive time must be positive");
        this.keepAliveTimeNanos = timeUnit.toNanos(keepAliveTime);
        this.keepAliveTimeNanos = KeepAliveManager.clampKeepAliveTimeInNanos(this.keepAliveTimeNanos);
        if (this.keepAliveTimeNanos >= AS_LARGE_AS_INFINITE) {
            this.keepAliveTimeNanos = Long.MAX_VALUE;
        }
        return this;
    }

    @Override
    @CheckReturnValue
    protected ClientTransportFactory buildTransportFactory() {
        return new NettyTransportFactory(this.dynamicParamsFactory, this.channelType, this.channelOptions, this.negotiationType, this.sslContext, this.eventLoopGroup, this.flowControlWindow, this.maxInboundMessageSize(), this.maxHeaderListSize, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, this.transportTracerFactory.create());
    }

    @Override
    @CheckReturnValue
    protected Attributes getNameResolverParams() {
        int defaultPort;
        switch (this.negotiationType) {
            case PLAINTEXT: 
            case PLAINTEXT_UPGRADE: {
                defaultPort = 80;
                break;
            }
            case TLS: {
                defaultPort = 443;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
            }
        }
        return Attributes.newBuilder().set(NameResolver.Factory.PARAMS_DEFAULT_PORT, defaultPort).build();
    }

    @CheckReturnValue
    static ProtocolNegotiator createProtocolNegotiator(String authority, NegotiationType negotiationType, SslContext sslContext, ProxyParameters proxy) {
        ProtocolNegotiator negotiator = NettyChannelBuilder.createProtocolNegotiatorByType(authority, negotiationType, sslContext);
        if (proxy != null) {
            negotiator = ProtocolNegotiators.httpProxy(proxy.proxyAddress, proxy.username, proxy.password, negotiator);
        }
        return negotiator;
    }

    @CheckReturnValue
    private static ProtocolNegotiator createProtocolNegotiatorByType(String authority, NegotiationType negotiationType, SslContext sslContext) {
        switch (negotiationType) {
            case PLAINTEXT: {
                return ProtocolNegotiators.plaintext();
            }
            case PLAINTEXT_UPGRADE: {
                return ProtocolNegotiators.plaintextUpgrade();
            }
            case TLS: {
                return ProtocolNegotiators.tls(sslContext, authority);
            }
        }
        throw new IllegalArgumentException("Unsupported negotiationType: " + (Object)((Object)negotiationType));
    }

    @Override
    @CheckReturnValue
    protected String checkAuthority(String authority) {
        if (this.authorityChecker != null) {
            return this.authorityChecker.checkAuthority(authority);
        }
        return super.checkAuthority(authority);
    }

    @CheckReturnValue
    private static final class NettyTransportFactory
    implements ClientTransportFactory {
        private final TransportCreationParamsFilterFactory transportCreationParamsFilterFactory;
        private final Class<? extends Channel> channelType;
        private final Map<ChannelOption<?>, ?> channelOptions;
        private final NegotiationType negotiationType;
        private final EventLoopGroup group;
        private final boolean usingSharedGroup;
        private final int flowControlWindow;
        private final int maxMessageSize;
        private final int maxHeaderListSize;
        private final AtomicBackoff keepAliveTimeNanos;
        private final long keepAliveTimeoutNanos;
        private final boolean keepAliveWithoutCalls;
        private final TransportTracer transportTracer;
        private boolean closed;

        NettyTransportFactory(TransportCreationParamsFilterFactory transportCreationParamsFilterFactory, Class<? extends Channel> channelType, Map<ChannelOption<?>, ?> channelOptions, NegotiationType negotiationType, SslContext sslContext, EventLoopGroup group, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, TransportTracer transportTracer) {
            this.channelType = channelType;
            this.negotiationType = negotiationType;
            this.channelOptions = new HashMap(channelOptions);
            this.transportTracer = transportTracer;
            if (transportCreationParamsFilterFactory == null) {
                transportCreationParamsFilterFactory = new DefaultNettyTransportCreationParamsFilterFactory(sslContext);
            }
            this.transportCreationParamsFilterFactory = transportCreationParamsFilterFactory;
            this.flowControlWindow = flowControlWindow;
            this.maxMessageSize = maxMessageSize;
            this.maxHeaderListSize = maxHeaderListSize;
            this.keepAliveTimeNanos = new AtomicBackoff("keepalive time nanos", keepAliveTimeNanos);
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.keepAliveWithoutCalls = keepAliveWithoutCalls;
            this.usingSharedGroup = group == null;
            this.group = this.usingSharedGroup ? SharedResourceHolder.get(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP) : group;
        }

        @Override
        public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, ClientTransportFactory.ClientTransportOptions options) {
            Preconditions.checkState(!this.closed, "The transport factory is closed.");
            TransportCreationParamsFilter dparams = this.transportCreationParamsFilterFactory.create(serverAddress, options.getAuthority(), options.getUserAgent(), options.getProxyParameters());
            final AtomicBackoff.State keepAliveTimeNanosState = this.keepAliveTimeNanos.getState();
            Runnable tooManyPingsRunnable = new Runnable(){

                @Override
                public void run() {
                    keepAliveTimeNanosState.backoff();
                }
            };
            NettyClientTransport transport = new NettyClientTransport(dparams.getTargetServerAddress(), this.channelType, this.channelOptions, this.group, dparams.getProtocolNegotiator(), this.flowControlWindow, this.maxMessageSize, this.maxHeaderListSize, keepAliveTimeNanosState.get(), this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls, dparams.getAuthority(), dparams.getUserAgent(), tooManyPingsRunnable, this.transportTracer, options.getEagAttributes());
            return transport;
        }

        @Override
        public ScheduledExecutorService getScheduledExecutorService() {
            return this.group;
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedGroup) {
                SharedResourceHolder.release(Utils.DEFAULT_WORKER_EVENT_LOOP_GROUP, this.group);
            }
        }

        private final class DefaultNettyTransportCreationParamsFilterFactory
        implements TransportCreationParamsFilterFactory {
            private final SslContext sslContext;

            private DefaultNettyTransportCreationParamsFilterFactory(SslContext sslContext) {
                if (NettyTransportFactory.this.negotiationType == NegotiationType.TLS && sslContext == null) {
                    try {
                        sslContext = GrpcSslContexts.forClient().build();
                    }
                    catch (SSLException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                this.sslContext = sslContext;
            }

            @Override
            public TransportCreationParamsFilter create(SocketAddress targetServerAddress, String authority, String userAgent, ProxyParameters proxyParams) {
                return new DynamicNettyTransportParams(targetServerAddress, authority, userAgent, proxyParams);
            }

            @CheckReturnValue
            private final class DynamicNettyTransportParams
            implements TransportCreationParamsFilter {
                private final SocketAddress targetServerAddress;
                private final String authority;
                @Nullable
                private final String userAgent;
                private ProxyParameters proxyParams;

                private DynamicNettyTransportParams(SocketAddress targetServerAddress, String authority, String userAgent, ProxyParameters proxyParams) {
                    this.targetServerAddress = targetServerAddress;
                    this.authority = authority;
                    this.userAgent = userAgent;
                    this.proxyParams = proxyParams;
                }

                @Override
                public SocketAddress getTargetServerAddress() {
                    return this.targetServerAddress;
                }

                @Override
                public String getAuthority() {
                    return this.authority;
                }

                @Override
                public String getUserAgent() {
                    return this.userAgent;
                }

                @Override
                public ProtocolNegotiator getProtocolNegotiator() {
                    return NettyChannelBuilder.createProtocolNegotiator(this.authority, NettyTransportFactory.this.negotiationType, DefaultNettyTransportCreationParamsFilterFactory.this.sslContext, this.proxyParams);
                }
            }
        }
    }

    @CheckReturnValue
    static interface TransportCreationParamsFilter {
        public SocketAddress getTargetServerAddress();

        public String getAuthority();

        @Nullable
        public String getUserAgent();

        public ProtocolNegotiator getProtocolNegotiator();
    }

    static interface TransportCreationParamsFilterFactory {
        @CheckReturnValue
        public TransportCreationParamsFilter create(SocketAddress var1, String var2, @Nullable String var3, @Nullable ProxyParameters var4);
    }

    @CheckReturnValue
    static interface OverrideAuthorityChecker {
        public String checkAuthority(String var1);
    }
}

