/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.grpc.netty;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.io.grpc.InternalMetadata;
import org.glowroot.agent.shaded.io.grpc.Metadata;
import org.glowroot.agent.shaded.io.grpc.Status;
import org.glowroot.agent.shaded.io.grpc.internal.GrpcUtil;
import org.glowroot.agent.shaded.io.grpc.internal.SharedResourceHolder;
import org.glowroot.agent.shaded.io.grpc.internal.TransportFrameUtil;
import org.glowroot.agent.shaded.io.grpc.netty.GrpcHttp2HeadersUtils;
import org.glowroot.agent.shaded.io.grpc.netty.GrpcHttp2OutboundHeaders;
import org.glowroot.agent.shaded.io.netty.channel.EventLoopGroup;
import org.glowroot.agent.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Exception;
import org.glowroot.agent.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.glowroot.agent.shaded.io.netty.util.AsciiString;
import org.glowroot.agent.shaded.io.netty.util.CharsetUtil;
import org.glowroot.agent.shaded.io.netty.util.concurrent.DefaultThreadFactory;

class Utils {
    public static final AsciiString STATUS_OK = AsciiString.of("200");
    public static final AsciiString HTTP_METHOD = AsciiString.of("POST");
    public static final AsciiString HTTP_GET_METHOD = AsciiString.of("GET");
    public static final AsciiString HTTPS = AsciiString.of("https");
    public static final AsciiString HTTP = AsciiString.of("http");
    public static final AsciiString CONTENT_TYPE_HEADER = AsciiString.of(GrpcUtil.CONTENT_TYPE_KEY.name());
    public static final AsciiString CONTENT_TYPE_GRPC = AsciiString.of("application/grpc");
    public static final AsciiString TE_HEADER = AsciiString.of(GrpcUtil.TE_HEADER.name());
    public static final AsciiString TE_TRAILERS = AsciiString.of("trailers");
    public static final AsciiString USER_AGENT = AsciiString.of(GrpcUtil.USER_AGENT_KEY.name());
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG");
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG");
    static boolean validateHeaders = false;

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        if (http2Headers instanceof GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders) {
            GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders h = (GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers;
            return InternalMetadata.newMetadata(h.numHeaders(), h.namesAndValues());
        }
        return InternalMetadata.newMetadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Map.Entry<CharSequence, CharSequence> entry : http2Headers) {
            headerValues[i++] = Utils.bytes(entry.getKey());
            headerValues[i++] = Utils.bytes(entry.getValue());
        }
        return TransportFrameUtil.toRawSerializedHeaders(headerValues);
    }

    private static byte[] bytes(CharSequence seq) {
        if (seq instanceof AsciiString) {
            AsciiString str = (AsciiString)seq;
            return str.isEntireArrayUsed() ? str.array() : str.toByteArray();
        }
        return seq.toString().getBytes(CharsetUtil.UTF_8);
    }

    public static Http2Headers convertClientHeaders(Metadata headers, AsciiString scheme, AsciiString defaultPath, AsciiString authority, AsciiString method, AsciiString userAgent) {
        Preconditions.checkNotNull(defaultPath, "defaultPath");
        Preconditions.checkNotNull(authority, "authority");
        Preconditions.checkNotNull(method, "method");
        headers.discardAll(GrpcUtil.CONTENT_TYPE_KEY);
        headers.discardAll(GrpcUtil.TE_HEADER);
        headers.discardAll(GrpcUtil.USER_AGENT_KEY);
        return GrpcHttp2OutboundHeaders.clientRequestHeaders(TransportFrameUtil.toHttp2Headers(headers), authority, defaultPath, method, scheme, userAgent);
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        if (http2Headers instanceof GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders) {
            GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders h = (GrpcHttp2HeadersUtils.GrpcHttp2InboundHeaders)http2Headers;
            return InternalMetadata.newMetadata(h.numHeaders(), h.namesAndValues());
        }
        return InternalMetadata.newMetadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Status statusFromThrowable(Throwable t) {
        Status s = Status.fromThrowable(t);
        if (s.getCode() != Status.Code.UNKNOWN) {
            return s;
        }
        if (t instanceof ClosedChannelException) {
            ClosedChannelException extraT = new ClosedChannelException();
            extraT.initCause(t);
            return Status.UNKNOWN.withDescription("channel closed").withCause(extraT);
        }
        if (t instanceof IOException) {
            return Status.UNAVAILABLE.withDescription("io exception").withCause(t);
        }
        if (t instanceof Http2Exception) {
            return Status.INTERNAL.withDescription("http2 exception").withCause(t);
        }
        return s;
    }

    private static class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;

        DefaultEventLoopGroupResource(int numEventLoops, String name) {
            this.name = name;
            this.numEventLoops = numEventLoops;
        }

        @Override
        public EventLoopGroup create() {
            boolean useDaemonThreads = true;
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(this.name, useDaemonThreads);
            int parallelism = this.numEventLoops == 0 ? Runtime.getRuntime().availableProcessors() * 2 : this.numEventLoops;
            return new NioEventLoopGroup(parallelism, threadFactory);
        }

        @Override
        public void close(EventLoopGroup instance) {
            instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public String toString() {
            return this.name;
        }
    }
}

