/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.shaded.io.netty.handler.codec.http;

import org.glowroot.agent.shaded.io.netty.handler.codec.http.CombinedHttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.DefaultHttpObject;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpMessage;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpVersion;
import org.glowroot.agent.shaded.io.netty.util.internal.ObjectUtil;

public abstract class DefaultHttpMessage
extends DefaultHttpObject
implements HttpMessage {
    private HttpVersion version;
    private final HttpHeaders headers;

    protected DefaultHttpMessage(HttpVersion version, boolean validateHeaders, boolean singleFieldHeaders) {
        this(version, singleFieldHeaders ? new CombinedHttpHeaders(validateHeaders) : new DefaultHttpHeaders(validateHeaders));
    }

    protected DefaultHttpMessage(HttpVersion version, HttpHeaders headers) {
        this.version = ObjectUtil.checkNotNull(version, "version");
        this.headers = ObjectUtil.checkNotNull(headers, "headers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public HttpVersion protocolVersion() {
        return this.version;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultHttpMessage)) {
            return false;
        }
        DefaultHttpMessage other = (DefaultHttpMessage)o;
        return this.headers().equals(other.headers()) && this.protocolVersion().equals(other.protocolVersion()) && super.equals(o);
    }
}

